/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.report;

import com.blackducksoftware.integration.hub.api.report.AggregateBomViewEntry;
import com.blackducksoftware.integration.hub.api.report.DetailedReleaseSummary;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class VersionReport {
    private final DetailedReleaseSummary detailedReleaseSummary;
    private final List<AggregateBomViewEntry> aggregateBomViewEntries;

    public VersionReport(DetailedReleaseSummary detailedReleaseSummary, List<AggregateBomViewEntry> aggregateBomViewEntries) {
        this.detailedReleaseSummary = detailedReleaseSummary;
        this.aggregateBomViewEntries = aggregateBomViewEntries;
    }

    public DetailedReleaseSummary getDetailedReleaseSummary() {
        return this.detailedReleaseSummary;
    }

    public String getBaseUrl() {
        if (this.detailedReleaseSummary == null || this.detailedReleaseSummary.getUiUrlGenerator() == null) {
            return null;
        }
        return this.detailedReleaseSummary.getUiUrlGenerator().getBaseUrl();
    }

    public String getReportProjectUrl() {
        if (this.detailedReleaseSummary == null || StringUtils.isBlank(this.getBaseUrl()) || StringUtils.isBlank(this.detailedReleaseSummary.getProjectId())) {
            return null;
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.getBaseUrl());
        urlBuilder.append("#");
        urlBuilder.append("projects/id:");
        urlBuilder.append(this.detailedReleaseSummary.getProjectId());
        return urlBuilder.toString();
    }

    public String getReportVersionUrl() {
        if (this.detailedReleaseSummary == null || StringUtils.isBlank(this.getBaseUrl()) || StringUtils.isBlank(this.detailedReleaseSummary.getVersionId())) {
            return null;
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.getBaseUrl());
        urlBuilder.append("#");
        urlBuilder.append("versions/id:");
        urlBuilder.append(this.detailedReleaseSummary.getVersionId());
        urlBuilder.append("/view:bom");
        return urlBuilder.toString();
    }

    public String getComponentUrl(AggregateBomViewEntry entry) {
        if (StringUtils.isBlank(this.getBaseUrl()) || entry == null || entry.getProducerProject() == null || StringUtils.isBlank(entry.getProducerProject().getId())) {
            return null;
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.getBaseUrl());
        urlBuilder.append("#");
        urlBuilder.append("projects/id:");
        urlBuilder.append(entry.getProducerProject().getId());
        return urlBuilder.toString();
    }

    public String getVersionUrl(AggregateBomViewEntry entry) {
        if (StringUtils.isBlank(this.getBaseUrl()) || entry == null || entry.getProducerReleases() == null || StringUtils.isBlank(entry.getProducerReleasesId())) {
            return null;
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.getBaseUrl());
        urlBuilder.append("#");
        urlBuilder.append("versions/id:");
        urlBuilder.append(entry.getProducerReleasesId());
        return urlBuilder.toString();
    }

    public List<AggregateBomViewEntry> getAggregateBomViewEntries() {
        return this.aggregateBomViewEntries;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aggregateBomViewEntries == null ? 0 : this.aggregateBomViewEntries.hashCode());
        result = 31 * result + (this.detailedReleaseSummary == null ? 0 : this.detailedReleaseSummary.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionReport)) {
            return false;
        }
        VersionReport other = (VersionReport)obj;
        if (this.aggregateBomViewEntries == null ? other.aggregateBomViewEntries != null : !this.aggregateBomViewEntries.equals(other.aggregateBomViewEntries)) {
            return false;
        }
        return !(this.detailedReleaseSummary == null ? other.detailedReleaseSummary != null : !this.detailedReleaseSummary.equals(other.detailedReleaseSummary));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VersionReport [detailedReleaseSummary=");
        builder.append(this.detailedReleaseSummary);
        builder.append(", aggregateBomViewEntries=");
        builder.append(this.aggregateBomViewEntries);
        builder.append("]");
        return builder.toString();
    }
}

