'use strict';

(function () {

    var BlackduckQueryTileViewController = function ($scope, BlackduckQueryService, XlrTileHelper) {
        var vm = this;

        vm.tileConfigurationIsPopulated = tileConfigurationIsPopulated;

        var tile;

        if ($scope.xlrDashboard) {
            // summary page
            vm.release = $scope.xlrDashboard.release;
            vm.tile = $scope.xlrTile.tile;
            if (vm.tile.properties == null) {
                vm.config = vm.tile.configurationProperties;
            } else {
                // new style since 7.0
                vm.config = vm.tile.properties;
            }
        }

        function tileConfigurationIsPopulated() {
            return !_.isEmpty(vm.config.blackduckServer);
        }

        function load(config) {
            if (tileConfigurationIsPopulated()) {
                vm.loading = true;
                BlackduckQueryService.executeQuery(vm.tile.id, config).then(
                    function (response) {
                        vm.result = response.data.data;
                        if (!vm.result.error) {
                            $scope.xlrTile.title = vm.tile.title + " : " + vm.result['projectName'] + "-" +vm.result['projectVersion'];
                            var categories = ['None', 'Low', 'Medium', 'High'];
                            var counts = [];
                            for (var i in categories) {
                                counts.push(vm.result['riskProfile'][categories[i]])
                            }
                            vm.riskReportBarChartData = createEchartOptions(categories, counts);
                        }
                    }
                ).finally(function () {
                    vm.loading = false;

                });
            }
        }

        function createEchartOptions(categories, counts) {
        return {
            yAxis: {
                type: 'category',
                data: categories,
                axisLine: { show: false },
                axisTick: { show: false },
                axisPointer: { show: false }
            },
            xAxis: {
                show: false,
                type: 'value',
                axisLabel: {
                    show: false
                }
            },
            series: [{
                data: counts,
                type: 'bar',
                itemStyle: {
                        normal: {
                            color: function(params) {
                                var colorList = [
                                  'rgb(221, 221, 221)','rgb(153, 153, 153)','rgb(231, 140, 135)','rgb(156, 37, 31)'
                                ];
                                return colorList[params.dataIndex]
                            },
                            label: {
                                show: true,
                                position: 'right',
                                formatter: '{c}',
                                color: 'rgb(0,0,0)'
                            }
                        }
                    }
                }]
            };
        }
        function refresh() {
            load({params: {refresh: true}});
        }

        refresh();

        vm.refresh = refresh;
    };

    BlackduckQueryTileViewController.$inject = ['$scope', 'xlrelease.blackduck.BlackduckQueryService', 'XlrTileHelper'];

    var BlackduckQueryService = function (Backend) {

        function executeQuery(tileId, config) {
            return Backend.get("tiles/" + tileId + "/data", config);
        }

        return {
            executeQuery: executeQuery
        };
    };

    BlackduckQueryService.$inject = ['Backend'];

    angular.module('xlrelease.blackduck.tile', []);
    angular.module('xlrelease.blackduck.tile').service('xlrelease.blackduck.BlackduckQueryService', BlackduckQueryService);
    angular.module('xlrelease.blackduck.tile').controller('blackduck.BlackduckQueryTileViewController', BlackduckQueryTileViewController);

})();

