/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.phonehome;

import com.blackducksoftware.integration.builder.AbstractBuilder;
import com.blackducksoftware.integration.phonehome.PhoneHomeRequestBody;
import com.blackducksoftware.integration.phonehome.PhoneHomeRequestBodyValidator;
import com.blackducksoftware.integration.phonehome.enums.BlackDuckName;
import com.blackducksoftware.integration.phonehome.enums.PhoneHomeRequestFieldEnum;
import com.blackducksoftware.integration.phonehome.enums.PhoneHomeSource;
import com.blackducksoftware.integration.phonehome.enums.ThirdPartyName;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class PhoneHomeRequestBodyBuilder
extends AbstractBuilder<PhoneHomeRequestBody> {
    private String registrationId;
    private String hostName;
    private String blackDuckName;
    private String blackDuckVersion;
    private String thirdPartyName;
    private String thirdPartyVersion;
    private String pluginVersion;
    private String source;
    private final Map<String, String> metaDataMap = new HashMap<String, String>();

    @Override
    public PhoneHomeRequestBody buildObject() {
        String hubIdentifier;
        try {
            hubIdentifier = this.registrationId == null ? this.md5Hash(this.hostName) : this.registrationId;
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            hubIdentifier = null;
        }
        Map<String, String> infoMap = this.metaDataMap;
        infoMap.put(PhoneHomeRequestFieldEnum.BLACKDUCKNAME.getKey(), this.blackDuckName);
        infoMap.put(PhoneHomeRequestFieldEnum.BLACKDUCKVERSION.getKey(), this.blackDuckVersion);
        infoMap.put(PhoneHomeRequestFieldEnum.THIRDPARTYNAME.getKey(), this.thirdPartyName);
        infoMap.put(PhoneHomeRequestFieldEnum.THIRDPARTYVERSION.getKey(), this.thirdPartyVersion);
        infoMap.put(PhoneHomeRequestFieldEnum.PLUGINVERSION.getKey(), this.pluginVersion);
        PhoneHomeRequestBody info = new PhoneHomeRequestBody(hubIdentifier, this.source, infoMap);
        return info;
    }

    @Override
    public PhoneHomeRequestBodyValidator createValidator() {
        PhoneHomeRequestBodyValidator phoneHomeRequestValidator = new PhoneHomeRequestBodyValidator();
        phoneHomeRequestValidator.setBlackDuckName(this.blackDuckName);
        phoneHomeRequestValidator.setBlackDuckVersion(this.blackDuckVersion);
        phoneHomeRequestValidator.setHostName(this.hostName);
        phoneHomeRequestValidator.setPluginVersion(this.pluginVersion);
        phoneHomeRequestValidator.setRegistrationId(this.registrationId);
        phoneHomeRequestValidator.setThirdPartyName(this.thirdPartyName);
        phoneHomeRequestValidator.setThirdPartyVersion(this.thirdPartyVersion);
        phoneHomeRequestValidator.setSource(this.source);
        return phoneHomeRequestValidator;
    }

    public String md5Hash(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] hashedBytes = md.digest(string.getBytes("UTF-8"));
        return DigestUtils.md5Hex((byte[])hashedBytes);
    }

    public Map<String, String> getMetaDataMap() {
        return this.metaDataMap;
    }

    public void addToMetaDataMap(String key, String value) {
        this.metaDataMap.put(key, value);
    }

    public String getRegistrationId() {
        return this.registrationId;
    }

    public void setRegistrationId(String registrationId) {
        this.registrationId = registrationId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getBlackDuckName() {
        return this.blackDuckName;
    }

    public void setBlackDuckName(BlackDuckName blackDuckName) {
        this.blackDuckName = blackDuckName.getName();
    }

    public void setBlackDuckName(String blackDuckName) {
        this.blackDuckName = blackDuckName;
    }

    public String getBlackDuckVersion() {
        return this.blackDuckVersion;
    }

    public void setBlackDuckVersion(String blackDuckVersion) {
        this.blackDuckVersion = blackDuckVersion;
    }

    public String getThirdPartyName() {
        return this.thirdPartyName;
    }

    public void setThirdPartyName(ThirdPartyName thirdPartyName) {
        this.thirdPartyName = thirdPartyName.getName();
    }

    public void setThirdPartyName(String thirdPartyName) {
        this.thirdPartyName = thirdPartyName;
    }

    public String getThirdPartyVersion() {
        return this.thirdPartyVersion;
    }

    public void setThirdPartyVersion(String thirdPartyVersion) {
        this.thirdPartyVersion = thirdPartyVersion;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(PhoneHomeSource source) {
        this.source = source.getName();
    }

    public void setSource(String source) {
        this.source = source;
    }
}

