/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.request.validator;

import com.blackducksoftware.integration.hub.model.enumeration.ProjectVersionDistributionEnum;
import com.blackducksoftware.integration.hub.model.enumeration.ProjectVersionPhaseEnum;
import com.blackducksoftware.integration.hub.request.ProjectRequestField;
import com.blackducksoftware.integration.hub.request.ProjectVersionRequestField;
import com.blackducksoftware.integration.validator.AbstractValidator;
import com.blackducksoftware.integration.validator.ValidationResult;
import com.blackducksoftware.integration.validator.ValidationResultEnum;
import com.blackducksoftware.integration.validator.ValidationResults;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;

public class ProjectRequestValidator
extends AbstractValidator {
    private String projectName;
    private String description;
    private Boolean projectLevelAdjustments;
    private String projectOwner;
    private Integer projectTier;
    private String distribution;
    private String phase;
    private String versionName;
    private String versionNickname;
    private String releaseComments;
    private String releasedOn;

    @Override
    public ValidationResults assertValid() {
        ValidationResults result = new ValidationResults();
        this.validateProject(result);
        this.validateVersion(result);
        return result;
    }

    public void validateProject(ValidationResults result) {
        if (StringUtils.isBlank(this.projectName)) {
            result.addResult(ProjectRequestField.NAME, new ValidationResult(ValidationResultEnum.ERROR, "Did not provide a project name."));
        }
    }

    public void validateVersion(ValidationResults result) {
        if (StringUtils.isBlank(this.versionName)) {
            result.addResult(ProjectVersionRequestField.VERSIONNAME, new ValidationResult(ValidationResultEnum.ERROR, "Did not provide a version name."));
        }
        if (StringUtils.isBlank(this.distribution)) {
            result.addResult(ProjectVersionRequestField.DISTRIBUTION, new ValidationResult(ValidationResultEnum.ERROR, "Did not provide a version distribution."));
        } else {
            try {
                ProjectVersionDistributionEnum.valueOf(this.distribution.toUpperCase());
            }
            catch (Exception e) {
                result.addResult(ProjectVersionRequestField.DISTRIBUTION, new ValidationResult(ValidationResultEnum.ERROR, e.getMessage(), e));
            }
        }
        if (StringUtils.isBlank(this.phase)) {
            result.addResult(ProjectVersionRequestField.PHASE, new ValidationResult(ValidationResultEnum.ERROR, "Did not provide a version phase."));
        } else {
            try {
                ProjectVersionPhaseEnum.valueOf(this.phase.toUpperCase());
            }
            catch (Exception e) {
                result.addResult(ProjectVersionRequestField.PHASE, new ValidationResult(ValidationResultEnum.ERROR, e.getMessage(), e));
            }
        }
        if (StringUtils.isNotBlank(this.releasedOn)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
                sdf.parse(this.releasedOn);
            }
            catch (Exception e) {
                result.addResult(ProjectVersionRequestField.RELEASEDON, new ValidationResult(ValidationResultEnum.ERROR, e.getMessage(), e));
            }
        }
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setProjectLevelAdjustments(Boolean projectLevelAdjustments) {
        this.projectLevelAdjustments = projectLevelAdjustments;
    }

    public void setProjectOwner(String projectOwner) {
        this.projectOwner = projectOwner;
    }

    public void setProjectTier(Integer projectTier) {
        this.projectTier = projectTier;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public void setVersionNickname(String versionNickname) {
        this.versionNickname = versionNickname;
    }

    public void setReleaseComments(String releaseComments) {
        this.releaseComments = releaseComments;
    }

    public void setReleasedOn(String releasedOn) {
        this.releasedOn = releasedOn;
    }
}

