/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.notification.transformer;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.notification.NotificationService;
import com.blackducksoftware.integration.hub.api.policy.PolicyService;
import com.blackducksoftware.integration.hub.api.project.version.ProjectVersionService;
import com.blackducksoftware.integration.hub.api.view.MetaHandler;
import com.blackducksoftware.integration.hub.dataservice.model.ProjectVersionModel;
import com.blackducksoftware.integration.hub.dataservice.notification.model.NotificationContentItem;
import com.blackducksoftware.integration.hub.dataservice.notification.model.PolicyNotificationFilter;
import com.blackducksoftware.integration.hub.dataservice.notification.model.PolicyOverrideContentItem;
import com.blackducksoftware.integration.hub.dataservice.notification.transformer.AbstractPolicyTransformer;
import com.blackducksoftware.integration.hub.exception.HubItemTransformException;
import com.blackducksoftware.integration.hub.model.enumeration.VersionBomPolicyStatusOverallStatusEnum;
import com.blackducksoftware.integration.hub.model.view.BomComponentPolicyStatusView;
import com.blackducksoftware.integration.hub.model.view.ComponentVersionView;
import com.blackducksoftware.integration.hub.model.view.NotificationView;
import com.blackducksoftware.integration.hub.model.view.PolicyOverrideNotificationView;
import com.blackducksoftware.integration.hub.model.view.PolicyRuleView;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.model.view.components.ComponentVersionStatus;
import com.blackducksoftware.integration.hub.service.HubService;
import com.blackducksoftware.integration.log.IntLogger;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PolicyViolationOverrideTransformer
extends AbstractPolicyTransformer {
    public PolicyViolationOverrideTransformer(HubService hubResponseService, NotificationService notificationService, ProjectVersionService projectVersionService, PolicyService policyService, PolicyNotificationFilter policyFilter, MetaHandler metaService) {
        super(hubResponseService, notificationService, projectVersionService, policyService, policyFilter, metaService);
    }

    public PolicyViolationOverrideTransformer(HubService hubResponseService, IntLogger logger, NotificationService notificationService, ProjectVersionService projectVersionService, PolicyService policyService, PolicyNotificationFilter policyFilter, MetaHandler metaService) {
        super(hubResponseService, logger, notificationService, projectVersionService, policyService, policyFilter, metaService);
    }

    @Override
    public List<NotificationContentItem> transform(NotificationView item) throws HubItemTransformException {
        ProjectVersionView releaseItem;
        ArrayList<NotificationContentItem> templateData = new ArrayList<NotificationContentItem>();
        PolicyOverrideNotificationView policyOverride = (PolicyOverrideNotificationView)item;
        String projectName = policyOverride.content.projectName;
        ArrayList<ComponentVersionStatus> componentVersionList = new ArrayList<ComponentVersionStatus>();
        ComponentVersionStatus componentStatus = new ComponentVersionStatus();
        componentStatus.bomComponentVersionPolicyStatusLink = policyOverride.content.bomComponentVersionPolicyStatusLink;
        componentStatus.componentName = policyOverride.content.componentName;
        componentStatus.componentVersionLink = policyOverride.content.componentVersionLink;
        componentVersionList.add(componentStatus);
        try {
            releaseItem = this.getProjectVersionService().getView(policyOverride.content.projectVersionLink, ProjectVersionView.class);
        }
        catch (IntegrationException e) {
            throw new HubItemTransformException(e);
        }
        this.handleNotification(componentVersionList, projectName, releaseItem, item, templateData);
        return templateData;
    }

    @Override
    public void handleNotification(List<ComponentVersionStatus> componentVersionList, String projectName, ProjectVersionView releaseItem, NotificationView item, List<NotificationContentItem> templateData) throws HubItemTransformException {
        PolicyOverrideNotificationView policyOverrideItem = (PolicyOverrideNotificationView)item;
        for (ComponentVersionStatus componentVersion : componentVersionList) {
            try {
                ProjectVersionModel projectVersion;
                PolicyOverrideNotificationView policyOverride = (PolicyOverrideNotificationView)item;
                try {
                    projectVersion = this.createFullProjectVersion(policyOverride.content.projectVersionLink, projectName, releaseItem.versionName);
                }
                catch (IntegrationException e) {
                    throw new HubItemTransformException("Error getting ProjectVersion from Hub" + e.getMessage(), e);
                }
                String componentLink = policyOverrideItem.content.componentLink;
                String componentVersionLink = policyOverrideItem.content.componentVersionLink;
                ComponentVersionView fullComponentVersion = this.getComponentVersion(componentVersionLink);
                String bomComponentVersionPolicyStatusUrl = componentVersion.bomComponentVersionPolicyStatusLink;
                if (StringUtils.isBlank(bomComponentVersionPolicyStatusUrl)) {
                    this.getLogger().warn(String.format("bomComponentVersionPolicyStatus is missing for component %s; skipping it", componentVersion.componentName));
                    continue;
                }
                BomComponentPolicyStatusView bomComponentVersionPolicyStatus = this.getBomComponentVersionPolicyStatus(bomComponentVersionPolicyStatusUrl);
                if (bomComponentVersionPolicyStatus.approvalStatus != VersionBomPolicyStatusOverallStatusEnum.IN_VIOLATION_OVERRIDDEN) {
                    this.getLogger().debug(String.format("Component %s status is not 'violation overridden'; skipping it", componentVersion.componentName));
                    continue;
                }
                List<String> ruleList = this.getMatchingRuleUrls(policyOverrideItem.content.policies);
                if (ruleList == null || ruleList.isEmpty()) continue;
                ArrayList<PolicyRuleView> policyRuleList = new ArrayList<PolicyRuleView>();
                for (String ruleUrl : ruleList) {
                    PolicyRuleView rule = this.getPolicyRule(ruleUrl);
                    policyRuleList.add(rule);
                }
                this.createContents(projectVersion, componentVersion.componentName, fullComponentVersion, componentLink, componentVersionLink, policyRuleList, item, templateData, componentVersion.componentIssueLink);
            }
            catch (Exception e) {
                throw new HubItemTransformException(e);
            }
        }
    }

    @Override
    public void createContents(ProjectVersionModel projectVersion, String componentName, ComponentVersionView componentVersion, String componentUrl, String componentVersionUrl, List<PolicyRuleView> policyRuleList, NotificationView item, List<NotificationContentItem> templateData, String componentIssueUrl) throws URISyntaxException {
        PolicyOverrideNotificationView policyOverride = (PolicyOverrideNotificationView)item;
        templateData.add(new PolicyOverrideContentItem(item.createdAt, projectVersion, componentName, componentVersion, componentUrl, componentVersionUrl, policyRuleList, policyOverride.content.firstName, policyOverride.content.lastName, componentIssueUrl));
    }
}

