/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.builder;

import com.blackducksoftware.integration.builder.AbstractBuilder;
import com.blackducksoftware.integration.exception.IntegrationCertificateException;
import com.blackducksoftware.integration.hub.Credentials;
import com.blackducksoftware.integration.hub.CredentialsBuilder;
import com.blackducksoftware.integration.hub.global.HubServerConfig;
import com.blackducksoftware.integration.hub.proxy.ProxyInfo;
import com.blackducksoftware.integration.hub.proxy.ProxyInfoBuilder;
import com.blackducksoftware.integration.hub.validator.HubServerConfigValidator;
import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.log.LogLevel;
import com.blackducksoftware.integration.log.PrintStreamIntLogger;
import com.blackducksoftware.integration.validator.AbstractValidator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class HubServerConfigBuilder
extends AbstractBuilder<HubServerConfig> {
    public static int DEFAULT_TIMEOUT_SECONDS = 120;
    private String hubUrl;
    private String timeoutSeconds = String.valueOf(DEFAULT_TIMEOUT_SECONDS);
    private String username;
    private String password;
    private int passwordLength;
    private String apiKey;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private int proxyPasswordLength;
    private String ignoredProxyHosts;
    private boolean alwaysTrustServerCertificate;
    private IntLogger logger;

    @Override
    public HubServerConfig build() throws IllegalStateException {
        try {
            return (HubServerConfig)super.build();
        }
        catch (IllegalStateException stateException) {
            if (!stateException.getMessage().contains("SunCertPathBuilderException")) {
                throw stateException;
            }
            throw new IntegrationCertificateException(String.format("Please import the certificate for %s into your Java keystore.", this.hubUrl), stateException);
        }
    }

    @Override
    public HubServerConfig buildObject() {
        URL hubURL = null;
        try {
            String tempUrl = this.hubUrl;
            if (!tempUrl.endsWith("/")) {
                hubURL = new URL(tempUrl);
            } else {
                tempUrl = tempUrl.substring(0, tempUrl.length() - 1);
                hubURL = new URL(tempUrl);
            }
        }
        catch (MalformedURLException tempUrl) {
            // empty catch block
        }
        ProxyInfo proxyInfo = this.getHubProxyInfo();
        if (StringUtils.isNotBlank(this.apiKey)) {
            return new HubServerConfig(hubURL, NumberUtils.toInt(this.timeoutSeconds), this.apiKey, proxyInfo, this.alwaysTrustServerCertificate);
        }
        Credentials credentials = this.getHubCredentials();
        return new HubServerConfig(hubURL, NumberUtils.toInt(this.timeoutSeconds), credentials, proxyInfo, this.alwaysTrustServerCertificate);
    }

    private Credentials getHubCredentials() {
        CredentialsBuilder credentialsBuilder = new CredentialsBuilder();
        credentialsBuilder.setUsername(this.username);
        credentialsBuilder.setPassword(this.password);
        credentialsBuilder.setPasswordLength(this.passwordLength);
        return credentialsBuilder.buildObject();
    }

    private ProxyInfo getHubProxyInfo() {
        ProxyInfoBuilder proxyBuilder = new ProxyInfoBuilder();
        proxyBuilder.setHost(this.proxyHost);
        proxyBuilder.setPort(this.proxyPort);
        proxyBuilder.setIgnoredProxyHosts(this.ignoredProxyHosts);
        proxyBuilder.setUsername(this.proxyUsername);
        proxyBuilder.setPassword(this.proxyPassword);
        proxyBuilder.setPasswordLength(this.proxyPasswordLength);
        return proxyBuilder.buildObject();
    }

    @Override
    public AbstractValidator createValidator() {
        HubServerConfigValidator validator = new HubServerConfigValidator();
        validator.setHubUrl(this.hubUrl);
        validator.setUsername(this.username);
        validator.setPassword(this.password);
        validator.setApiKey(this.apiKey);
        validator.setTimeout(this.timeoutSeconds);
        validator.setProxyHost(this.proxyHost);
        validator.setProxyPort(this.proxyPort);
        validator.setIgnoredProxyHosts(this.ignoredProxyHosts);
        validator.setProxyUsername(this.proxyUsername);
        validator.setProxyPassword(this.proxyPassword);
        validator.setProxyPasswordLength(this.proxyPasswordLength);
        validator.setAlwaysTrustServerCertificate(this.alwaysTrustServerCertificate);
        return validator;
    }

    public void setFromProperties(Properties properties) {
        String hubUrl = properties.getProperty("hub.url");
        String hubUsername = properties.getProperty("hub.username");
        String hubPassword = properties.getProperty("hub.password");
        String hubApiKey = properties.getProperty("hub.api.key");
        String hubTimeout = properties.getProperty("hub.timeout");
        String hubProxyHost = properties.getProperty("hub.proxy.host");
        String hubProxyPort = properties.getProperty("hub.proxy.port");
        String hubIgnoredProxyHosts = properties.getProperty("hub.ignored.proxy.hosts");
        String hubProxyUsername = properties.getProperty("hub.proxy.username");
        String hubProxyPassword = properties.getProperty("hub.proxy.password");
        this.setHubUrl(hubUrl);
        this.setUsername(hubUsername);
        this.setPassword(hubPassword);
        this.setApiKey(hubApiKey);
        this.setTimeout(hubTimeout);
        this.setProxyHost(hubProxyHost);
        this.setProxyPort(hubProxyPort);
        this.setIgnoredProxyHosts(hubIgnoredProxyHosts);
        this.setProxyUsername(hubProxyUsername);
        this.setProxyPassword(hubProxyPassword);
    }

    public void setHubUrl(String hubUrl) {
        this.hubUrl = StringUtils.trimToNull(hubUrl);
    }

    public void setTimeout(String timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public void setTimeout(int timeoutSeconds) {
        this.setTimeout(String.valueOf(timeoutSeconds));
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordLength(int passwordLength) {
        this.passwordLength = passwordLength;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.setProxyPort(String.valueOf(proxyPort));
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setProxyPasswordLength(int proxyPasswordLength) {
        this.proxyPasswordLength = proxyPasswordLength;
    }

    public void setIgnoredProxyHosts(String ignoredProxyHosts) {
        this.ignoredProxyHosts = ignoredProxyHosts;
    }

    public void setAlwaysTrustServerCertificate(boolean alwaysTrustServerCertificate) {
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
    }

    public IntLogger getLogger() {
        if (this.logger == null) {
            this.logger = new PrintStreamIntLogger(System.out, LogLevel.INFO);
        }
        return this.logger;
    }

    public void setLogger(IntLogger logger) {
        this.logger = logger;
    }
}

