'use strict';

(() => {
    const xlrBlackduckCheckTaskDipOfInlineWithVariables = function () {
        return {
            scope: {
                propertyDefinitions: '=',
                propertyValues: '=',
                variables: '=',
                readOnly: '=',
                enforceMode: '=',
                showRequiredSign: '=?',
                // for task input properties of type text we don't use variable selector, for output properties we do
                showVariableSelectorForText: '=',
                onChange: '&',
                onNewVariable: '&'
            },
            restrict: 'AE',
            templateUrl: 'static/@project.version@/include/BlackduckCheckComplianceTask/directives/xlr-blackduck-check-task-dip-of-inline-with-variables.html',
            controller: 'xlrBlackduckCheckTaskDipOfInlineWithVariablesController',
            controllerAs: 'xlrDipCtrl',
            bindToController: true
        };
    };

const injectParams = ['$scope', 'ConfigurationInstances'];
const xlrBlackduckCheckTaskDipOfInlineWithVariablesController = function ($scope, ConfigurationInstances) {
    const vm = this;

    vm.showRequiredSign = _.isUndefined(vm.showRequiredSign) ? true : vm.showRequiredSign;
    vm.ConfigurationInstances = ConfigurationInstances;
    vm.onNewVariablePF = function (name, variableType, createdCallback) {
        vm.onNewVariable({
            name,
            variableType,
            createdCallback
        });
    };

    const selectOptions = {};
    vm.selectOptions = function(p) {
        if (_.isUndefined(selectOptions[p.name])) {
            selectOptions[p.name] = (p.required ? [] : [{
                title: "(None)",
                id: null
            }]).concat(ConfigurationInstances.getInstancesByType(p.referencedType));
        }
        return selectOptions[p.name];
    };

    if (!ConfigurationInstances.loaded()) {
        ConfigurationInstances.load();
    }
    $scope.$on('$destroy', function () {
        ConfigurationInstances.reset();
    });
};
xlrBlackduckCheckTaskDipOfInlineWithVariablesController.$inject = injectParams;

angular.module('xlrelease').controller('xlrBlackduckCheckTaskDipOfInlineWithVariablesController', xlrBlackduckCheckTaskDipOfInlineWithVariablesController);
angular.module('xlrelease').directive('xlrBlackduckCheckTaskDipOfInlineWithVariables', xlrBlackduckCheckTaskDipOfInlineWithVariables);

angular.module('xlrelease').directive('xlrBlackduckCheckTaskIntegerWithVariables', xlrBlackhubInputWithVariablesDirective({
    variableTypeId: 'IntegerVariable',
    templateUrl: 'static/@project.version@/include/BlackduckCheckComplianceTask/directives/xlr-blackduck-check-task-integer-with-variables.html'
}));

function xlrBlackhubInputWithVariablesDirective(viewParameters) {
    const directive = {
        scope: {
            name: '=',
            model: '=',
            onNew: '&',
            supportsNew: '=?',
            onChange: '&',
            variables: '=',
            options: '=',
            readOnly: '=',
            enforceMode: '=',
            description: '='
        },
        restrict: 'A',
        controller: XlrBlackhubInputWithVariablesController,
        controllerAs: 'vm',
        bindToController: true,
        templateUrl: viewParameters.templateUrl
    };

    XlrBlackhubInputWithVariablesController.$inject = ['$q', '$scope', 'VariablesService'];

    function XlrBlackhubInputWithVariablesController($q, $scope, VariablesService) {
        const vm = this;
        let draftIsInitialized = false;

        vm.handlers = {
            onSelect: variableSelectedHandler,
            addCandidates: variableAutocompleteHandler,
            onFormat (value) {
                let formattedValue = VariablesService.hasVariableSyntax(value) ? value : VariablesService.withVariableSyntax(value);

                // if formattedValue matches fully an existing variable name, take the full displayName to remove the 'New item' option
                const existingVariable = _.find(vm.variables, {variableName: formattedValue});
                if (existingVariable) {
                    formattedValue = existingVariable.displayName;
                }
                return formattedValue;
            }
        };

        const supportsNew = angular.isDefined(vm.supportsNew) ? vm.supportsNew : true;
        if (supportsNew) {
            vm.handlers.onNewItem = createNewVariableHandler;
        }

        vm.toggleMode = toggleMode;
        vm.onChangeInternal = onChangeInternal;

        vm.updateDraftFromModel = updateDraftFromModel;
        vm.updateModelFromDraft = updateModelFromDraft;

        const variableType = VariablesService.getVariableTypeById(viewParameters.variableTypeId);

        vm.variableType = variableType.key;
        vm.showToggle = _.isUndefined(vm.enforceMode);

        vm.variableTypeName = variableType.label;

        vm.commit = commit;

        calculateMode();

        function updateDraftFromModel(model) {
            vm.draft = {
                variable: _.find(vm.variables, {variableName: model.variable}),
                value: model.value
            };
        }

        function updateModelFromDraft(draft, variableMode) {
            const value = draft.value;
            const variableName = draft.variable ? draft.variable.variableName : null;
            _.extend(vm.model, {
                value: !variableMode ? value : null,
                variable: variableMode ? variableName : null
            });
        }

        /////

        $scope.$watch(function () {
            return {model: vm.model, variables: vm.variables};
        }, function (val) {

            const isValidModelValue = !(_.isNull(val.model) || _.isUndefined(val.model));

            if (!draftIsInitialized && isValidModelValue && val.variables) {
                vm.updateDraftFromModel(val.model);
                calculateMode();
                draftIsInitialized = true;
            }
        }, true);

        $scope.$watch('vm.draft.variable', function (newVariable, oldVariable) {
            if (oldVariable && !newVariable) {
                variableDeselectedHandler();
            }
        });

        function commit() {
            vm.updateModelFromDraft(vm.draft, vm.variableMode);
            vm.onChange();
        }

        function toggleMode() {
            vm.variableMode = !vm.variableMode;
            if (!vm.variableMode || (vm.variableMode && vm.draft.variable)) {
                commit();
            }
        }

        function createNewVariableHandler(variable) {
            const deferred = $q.defer();
            vm.updateModelFromDraft(vm.draft, vm.variableMode);
            vm.onNew({
                name: variable.displayName,
                variableType: vm.variableType,
                createdCallback (createdVariable) {
                    createdVariable.displayName = createdVariable.variableName = VariablesService.withVariableSyntax(createdVariable.key);
                    vm.variables.push(createdVariable);

                    _.extend(vm.model, {
                        value: null,
                        variable: VariablesService.getKey(createdVariable)
                    });

                    vm.onChange();
                    deferred.resolve(createdVariable.displayName);
                }
            });

            return deferred.promise;
        }

        function variableSelectedHandler(variable) {
            commit();
        }

        function variableDeselectedHandler() {
            commit();
        }

        function onChangeInternal() {
            commit();
        }

        function variableAutocompleteHandler(metadata, options) {
            const deferred = $q.defer();
            const candidates = _.filter(vm.variables, function (variable) {
                return vm.variableType === variable.type && variable.displayName.indexOf(options.term) !== -1;
            });
            deferred.resolve(candidates);
            return deferred.promise;
        }

        function calculateMode() {
            if (vm.enforceMode) {
                vm.variableMode = vm.enforceMode === 'variable';
            } else {
                vm.variableMode = vm.draft && !!vm.draft.variable;
            }
        }
    }

    return function () {
        return directive;
    };
}


})
();
