/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.validator;

import com.blackducksoftware.integration.hub.rest.oauth.AccessType;
import com.blackducksoftware.integration.hub.rest.oauth.OauthRestConnectionFieldEnum;
import com.blackducksoftware.integration.hub.rest.oauth.TokenManager;
import com.blackducksoftware.integration.hub.validator.AbstractRestConnectionValidator;
import com.blackducksoftware.integration.validator.ValidationResult;
import com.blackducksoftware.integration.validator.ValidationResultEnum;
import com.blackducksoftware.integration.validator.ValidationResults;

public class OauthRestConnectionValidator
extends AbstractRestConnectionValidator {
    public static final String ERROR_MSG_ACCESS_TYPE_NULL = "The access type cannot be null";
    public static final String ERROR_MSG_TOKEN_MANAGER_NULL = "The Token Manager cannot be null";
    private TokenManager tokenManager;
    private AccessType accessType;

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setTokenManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    @Override
    public void validateAdditionalFields(ValidationResults currentResults) {
        this.validateAccessType(currentResults);
        this.validateTokenManager(currentResults);
    }

    public void validateAccessType(ValidationResults result) {
        if (this.accessType == null) {
            result.addResult(OauthRestConnectionFieldEnum.ACCESSTYPE, new ValidationResult(ValidationResultEnum.ERROR, ERROR_MSG_ACCESS_TYPE_NULL));
        }
    }

    public void validateTokenManager(ValidationResults result) {
        if (this.tokenManager == null) {
            result.addResult(OauthRestConnectionFieldEnum.TOKENMANAGER, new ValidationResult(ValidationResultEnum.ERROR, ERROR_MSG_TOKEN_MANAGER_NULL));
        }
    }
}

