/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.parallel;

import com.blackducksoftware.integration.hub.dataservice.ItemTransform;
import com.blackducksoftware.integration.hub.dataservice.parallel.ParallelResourceProcessorResults;
import com.blackducksoftware.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class ParallelResourceProcessor<R, S> {
    private final Map<Class<?>, ItemTransform<List<R>, S>> transformerMap = new HashMap();
    private final ExecutorService executorService;
    private final ExecutorCompletionService<List<R>> completionService;
    private final IntLogger logger;

    public ParallelResourceProcessor(IntLogger logger) {
        this.logger = logger;
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), threadFactory);
        this.completionService = new ExecutorCompletionService(this.executorService);
    }

    public ParallelResourceProcessor(IntLogger logger, ExecutorService executorService, ExecutorCompletionService<List<R>> completionService) {
        this.logger = logger;
        this.executorService = executorService;
        this.completionService = completionService;
    }

    public void addTransform(Class<?> clazz, ItemTransform<List<R>, S> transform) {
        this.transformerMap.put(clazz, transform);
    }

    public void removeTransform(Class<?> clazz) {
        this.transformerMap.remove(clazz);
    }

    public ParallelResourceProcessorResults<R> process(List<S> itemsToProcess) {
        int submitted = this.submitItems(itemsToProcess);
        ParallelResourceProcessorResults<R> results = this.processItems(submitted);
        return results;
    }

    private int submitItems(List<S> itemList) {
        int submitted = 0;
        for (S item : itemList) {
            Class<?> key = item.getClass();
            if (!this.transformerMap.containsKey(key)) continue;
            ItemTransform<List<R>, S> converter = this.transformerMap.get(key);
            TransformCallable callable = new TransformCallable(item, converter);
            this.completionService.submit(callable);
            ++submitted;
        }
        return submitted;
    }

    private ParallelResourceProcessorResults<R> processItems(int submitted) {
        LinkedList<R> resultsList = new LinkedList<R>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (int index = 0; index < submitted; ++index) {
            try {
                Future<List<R>> future = this.completionService.take();
                List<R> contentItems = future.get();
                resultsList.addAll(contentItems);
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                String msg = "Error from parallel task: " + e.getMessage();
                this.logger.error(msg, e);
                exceptions.add(e);
            }
        }
        ParallelResourceProcessorResults resultsObject = new ParallelResourceProcessorResults(resultsList, exceptions);
        return resultsObject;
    }

    private class TransformCallable
    implements Callable<List<R>> {
        private final S item;
        private final ItemTransform<List<R>, S> converter;

        public TransformCallable(S item, ItemTransform<List<R>, S> converter) {
            this.item = item;
            this.converter = converter;
        }

        @Override
        public List<R> call() throws Exception {
            return this.converter.transform(this.item);
        }
    }
}

