/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.notification.transformer;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.notification.NotificationService;
import com.blackducksoftware.integration.hub.api.policy.PolicyService;
import com.blackducksoftware.integration.hub.api.project.version.ProjectVersionService;
import com.blackducksoftware.integration.hub.api.view.MetaHandler;
import com.blackducksoftware.integration.hub.dataservice.ItemTransform;
import com.blackducksoftware.integration.hub.dataservice.model.ProjectVersionModel;
import com.blackducksoftware.integration.hub.dataservice.notification.model.NotificationContentItem;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.exception.HubItemTransformException;
import com.blackducksoftware.integration.hub.model.view.ComponentVersionView;
import com.blackducksoftware.integration.hub.model.view.NotificationView;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.service.HubService;
import com.blackducksoftware.integration.log.IntBufferedLogger;
import com.blackducksoftware.integration.log.IntLogger;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractNotificationTransformer
implements ItemTransform<List<NotificationContentItem>, NotificationView> {
    private final IntLogger logger;
    private final HubService hubResponseService;
    private final NotificationService notificationService;
    private final ProjectVersionService projectVersionService;
    private final PolicyService policyService;
    private final MetaHandler metaService;

    public AbstractNotificationTransformer(HubService hubResponseService, NotificationService notificationService, ProjectVersionService projectVersionService, PolicyService policyService, MetaHandler metaService) {
        this.hubResponseService = hubResponseService;
        this.logger = new IntBufferedLogger();
        this.notificationService = notificationService;
        this.projectVersionService = projectVersionService;
        this.policyService = policyService;
        this.metaService = metaService;
    }

    public AbstractNotificationTransformer(HubService hubResponseService, IntLogger logger, NotificationService notificationService, ProjectVersionService projectVersionService, PolicyService policyService, MetaHandler metaService) {
        this.hubResponseService = hubResponseService;
        this.logger = logger;
        this.notificationService = notificationService;
        this.projectVersionService = projectVersionService;
        this.policyService = policyService;
        this.metaService = metaService;
    }

    public HubService getHubResponseService() {
        return this.hubResponseService;
    }

    protected IntLogger getLogger() {
        return this.logger;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public ProjectVersionService getProjectVersionService() {
        return this.projectVersionService;
    }

    public PolicyService getPolicyService() {
        return this.policyService;
    }

    @Override
    public abstract List<NotificationContentItem> transform(NotificationView var1) throws HubItemTransformException;

    protected ProjectVersionModel createFullProjectVersion(String projectVersionUrl, String projectName, String versionName) throws IntegrationException {
        ProjectVersionView item;
        try {
            item = this.hubResponseService.getView(projectVersionUrl, ProjectVersionView.class);
        }
        catch (HubIntegrationException e) {
            String msg = "Error getting the full ProjectVersion for this affected project version URL: " + projectVersionUrl + ": " + e.getMessage();
            throw new HubIntegrationException(msg, e);
        }
        ProjectVersionModel fullProjectVersion = new ProjectVersionModel();
        fullProjectVersion.setProjectName(projectName);
        fullProjectVersion.setProjectVersionName(versionName);
        fullProjectVersion.setDistribution(item.distribution);
        fullProjectVersion.setLicense(item.license);
        fullProjectVersion.setNickname(item.nickname);
        fullProjectVersion.setPhase(item.phase);
        fullProjectVersion.setReleaseComments(item.releaseComments);
        fullProjectVersion.setReleasedOn(item.releasedOn);
        fullProjectVersion.setSource(item.source);
        fullProjectVersion.setUrl(this.metaService.getHref(item));
        fullProjectVersion.setCodeLocationsLink(this.metaService.getFirstLinkSafely(item, "codelocations"));
        fullProjectVersion.setComponentsLink(this.metaService.getFirstLinkSafely(item, "components"));
        fullProjectVersion.setPolicyStatusLink(this.metaService.getFirstLinkSafely(item, "policy-status"));
        fullProjectVersion.setProjectLink(this.metaService.getFirstLinkSafely(item, "project"));
        fullProjectVersion.setRiskProfileLink(this.metaService.getFirstLinkSafely(item, "riskProfile"));
        fullProjectVersion.setVersionReportLink(this.metaService.getFirstLinkSafely(item, "versionReport"));
        fullProjectVersion.setVulnerableComponentsLink(this.metaService.getFirstLinkSafely(item, "vulnerable-components"));
        return fullProjectVersion;
    }

    public MetaHandler getMetaService() {
        return this.metaService;
    }

    protected ComponentVersionView getComponentVersion(String componentVersionLink) throws IntegrationException {
        ComponentVersionView componentVersion = null;
        if (!StringUtils.isBlank(componentVersionLink)) {
            componentVersion = this.hubResponseService.getView(componentVersionLink, ComponentVersionView.class);
        }
        return componentVersion;
    }

    protected String getComponentVersionName(String componentVersionLink) throws IntegrationException {
        ComponentVersionView compVersion;
        String componentVersionName = "";
        if (!StringUtils.isBlank(componentVersionLink) && (compVersion = this.getComponentVersion(componentVersionLink)) != null) {
            componentVersionName = compVersion.versionName;
        }
        return componentVersionName;
    }
}

