/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.notification;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.notification.NotificationService;
import com.blackducksoftware.integration.hub.api.policy.PolicyService;
import com.blackducksoftware.integration.hub.api.project.version.ProjectVersionService;
import com.blackducksoftware.integration.hub.api.view.MetaHandler;
import com.blackducksoftware.integration.hub.dataservice.notification.NotificationResults;
import com.blackducksoftware.integration.hub.dataservice.notification.model.NotificationContentItem;
import com.blackducksoftware.integration.hub.dataservice.notification.model.PolicyNotificationFilter;
import com.blackducksoftware.integration.hub.dataservice.notification.transformer.PolicyViolationClearedTransformer;
import com.blackducksoftware.integration.hub.dataservice.notification.transformer.PolicyViolationOverrideTransformer;
import com.blackducksoftware.integration.hub.dataservice.notification.transformer.PolicyViolationTransformer;
import com.blackducksoftware.integration.hub.dataservice.notification.transformer.VulnerabilityTransformer;
import com.blackducksoftware.integration.hub.dataservice.parallel.ParallelResourceProcessor;
import com.blackducksoftware.integration.hub.dataservice.parallel.ParallelResourceProcessorResults;
import com.blackducksoftware.integration.hub.model.view.NotificationView;
import com.blackducksoftware.integration.hub.model.view.PolicyOverrideNotificationView;
import com.blackducksoftware.integration.hub.model.view.RuleViolationClearedNotificationView;
import com.blackducksoftware.integration.hub.model.view.RuleViolationNotificationView;
import com.blackducksoftware.integration.hub.model.view.UserView;
import com.blackducksoftware.integration.hub.model.view.VulnerabilityNotificationView;
import com.blackducksoftware.integration.hub.service.HubService;
import com.blackducksoftware.integration.log.IntLogger;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;

public class NotificationDataService {
    private final HubService hubResponseService;
    private final NotificationService notificationRequestService;
    private final ProjectVersionService projectVersionRequestService;
    private final PolicyService policyRequestService;
    private final PolicyNotificationFilter policyNotificationFilter;
    private final ParallelResourceProcessor<NotificationContentItem, NotificationView> parallelProcessor;
    private final MetaHandler metaService;

    public NotificationDataService(IntLogger logger, HubService hubResponseService, NotificationService notificationRequestService, ProjectVersionService projectVersionRequestService, PolicyService policyRequestService) {
        this(logger, hubResponseService, notificationRequestService, projectVersionRequestService, policyRequestService, null);
    }

    public NotificationDataService(IntLogger logger, HubService hubResponseService, NotificationService notificationRequestService, ProjectVersionService projectVersionRequestService, PolicyService policyRequestService, PolicyNotificationFilter policyNotificationFilter) {
        this.hubResponseService = hubResponseService;
        this.notificationRequestService = notificationRequestService;
        this.projectVersionRequestService = projectVersionRequestService;
        this.policyRequestService = policyRequestService;
        this.policyNotificationFilter = policyNotificationFilter;
        this.parallelProcessor = new ParallelResourceProcessor(logger);
        this.metaService = new MetaHandler(logger);
        this.populateTransformerMap(logger);
    }

    private void populateTransformerMap(IntLogger logger) {
        this.parallelProcessor.addTransform(RuleViolationNotificationView.class, new PolicyViolationTransformer(this.hubResponseService, logger, this.notificationRequestService, this.projectVersionRequestService, this.policyRequestService, this.policyNotificationFilter, this.metaService));
        this.parallelProcessor.addTransform(PolicyOverrideNotificationView.class, new PolicyViolationOverrideTransformer(this.hubResponseService, logger, this.notificationRequestService, this.projectVersionRequestService, this.policyRequestService, this.policyNotificationFilter, this.metaService));
        this.parallelProcessor.addTransform(VulnerabilityNotificationView.class, new VulnerabilityTransformer(this.hubResponseService, this.notificationRequestService, this.projectVersionRequestService, this.policyRequestService, this.metaService, logger));
        this.parallelProcessor.addTransform(RuleViolationClearedNotificationView.class, new PolicyViolationClearedTransformer(this.hubResponseService, logger, this.notificationRequestService, this.projectVersionRequestService, this.policyRequestService, this.policyNotificationFilter, this.metaService));
    }

    public NotificationResults getAllNotifications(Date startDate, Date endDate) throws IntegrationException {
        TreeSet<NotificationContentItem> contentList = new TreeSet<NotificationContentItem>();
        List<NotificationView> itemList = this.notificationRequestService.getAllNotifications(startDate, endDate);
        ParallelResourceProcessorResults<NotificationContentItem> processorResults = this.parallelProcessor.process(itemList);
        contentList.addAll(processorResults.getResults());
        NotificationResults results = new NotificationResults(contentList, processorResults.getExceptions());
        return results;
    }

    public NotificationResults getUserNotifications(Date startDate, Date endDate, UserView user) throws IntegrationException {
        TreeSet<NotificationContentItem> contentList = new TreeSet<NotificationContentItem>();
        List<NotificationView> itemList = this.notificationRequestService.getUserNotifications(startDate, endDate, user);
        ParallelResourceProcessorResults<NotificationContentItem> processorResults = this.parallelProcessor.process(itemList);
        contentList.addAll(processorResults.getResults());
        NotificationResults results = new NotificationResults(contentList, processorResults.getExceptions());
        return results;
    }
}

