/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.license;

import com.blackducksoftware.integration.hub.model.enumeration.ComplexLicenseEnum;
import com.blackducksoftware.integration.hub.model.view.ComplexLicenseView;

public class ComplexLicenseParser {
    private final ComplexLicenseView complexLicense;
    private String licenseString;

    public ComplexLicenseParser(ComplexLicenseView complexLicense) {
        this.complexLicense = complexLicense;
    }

    public String parse() {
        if (this.licenseString == null) {
            this.licenseString = this.parse(this.complexLicense);
        }
        return this.licenseString;
    }

    private String parse(ComplexLicenseView complexLicense) {
        if (complexLicense.licenses != null && complexLicense.licenses.isEmpty()) {
            return complexLicense.name;
        }
        String operator = complexLicense.type == ComplexLicenseEnum.CONJUNCTIVE ? " AND " : " OR ";
        StringBuilder licenseText = new StringBuilder();
        int i = 1;
        for (ComplexLicenseView childLicense : complexLicense.licenses) {
            licenseText.append(this.parse(childLicense));
            if (i < complexLicense.licenses.size()) {
                licenseText.append(operator);
            }
            ++i;
        }
        return i > 2 ? "(" + licenseText.toString() + ")" : licenseText.toString();
    }
}

