/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.report;

import com.blackducksoftware.integration.hub.api.report.LicenseDefinition;
import com.blackducksoftware.integration.hub.api.report.ProjectData;
import com.blackducksoftware.integration.hub.api.report.ReleaseData;
import com.blackducksoftware.integration.hub.api.report.UserData;
import com.blackducksoftware.integration.hub.api.report.risk.RiskCounts;
import com.blackducksoftware.integration.hub.api.report.risk.RiskProfile;
import com.blackducksoftware.integration.hub.model.enumeration.VersionBomPolicyStatusOverallStatusEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.joda.time.DateTime;

public class AggregateBomViewEntry {
    private final List<String> bomEntryIds;
    private final List<Long> bomViewEntryIds;
    private final List<String> matchTypes;
    private final List<String> producerMatchTypes;
    private final List<String> componentMatchTypes;
    private final List<String> usages;
    private final List<Boolean> inUses;
    private final List<UserData> createdByUsers;
    private final String since;
    private final ProjectData producerProject;
    private final List<ReleaseData> producerReleases;
    private final List<LicenseDefinition> licenses;
    private final RiskProfile riskProfile;
    private final String policyApprovalStatus;

    public AggregateBomViewEntry(List<String> bomEntryIds, List<Long> bomViewEntryIds, List<String> matchTypes, List<String> producerMatchTypes, List<String> componentMatchTypes, List<String> usages, List<Boolean> inUses, List<UserData> createdByUsers, String since, ProjectData producerProject, List<ReleaseData> producerReleases, List<LicenseDefinition> licenses, RiskProfile riskProfile, String policyApprovalStatus) {
        this.bomEntryIds = bomEntryIds;
        this.bomViewEntryIds = bomViewEntryIds;
        this.matchTypes = matchTypes;
        this.producerMatchTypes = producerMatchTypes;
        this.componentMatchTypes = componentMatchTypes;
        this.usages = usages;
        this.inUses = inUses;
        this.createdByUsers = createdByUsers;
        this.since = since;
        this.producerProject = producerProject;
        this.producerReleases = producerReleases;
        this.licenses = licenses;
        this.riskProfile = riskProfile;
        this.policyApprovalStatus = policyApprovalStatus;
    }

    public String getPolicyApprovalStatus() {
        return this.policyApprovalStatus;
    }

    public VersionBomPolicyStatusOverallStatusEnum getPolicyApprovalStatusEnum() {
        return VersionBomPolicyStatusOverallStatusEnum.valueOf(this.policyApprovalStatus);
    }

    public List<String> getBomEntryIds() {
        return this.bomEntryIds;
    }

    public List<UUID> getBomEntryUUIds() {
        ArrayList<UUID> bomEntryUUIds = new ArrayList<UUID>();
        for (String bomEntryId : this.bomEntryIds) {
            if (StringUtils.isBlank(bomEntryId)) continue;
            try {
                bomEntryUUIds.add(UUID.fromString(bomEntryId));
            }
            catch (IllegalArgumentException e) {}
        }
        return bomEntryUUIds;
    }

    public List<Long> getBomViewEntryIds() {
        return this.bomViewEntryIds;
    }

    public List<String> getMatchTypes() {
        return this.matchTypes;
    }

    public List<String> getProducerMatchTypes() {
        return this.producerMatchTypes;
    }

    public List<String> getComponentMatchTypes() {
        return this.componentMatchTypes;
    }

    public List<String> getUsages() {
        return this.usages;
    }

    public List<Boolean> getInUses() {
        return this.inUses;
    }

    public List<UserData> getCreatedByUsers() {
        return this.createdByUsers;
    }

    public String getSince() {
        return this.since;
    }

    public List<LicenseDefinition> getLicenses() {
        return this.licenses;
    }

    public String getLicensesDisplay() {
        if (this.licenses == null || this.licenses.isEmpty()) {
            return "";
        }
        return this.licenses.get(0).getLicenseDisplay();
    }

    public RiskProfile getRiskProfile() {
        return this.riskProfile;
    }

    public RiskCounts getVulnerabilityRisk() {
        if (this.riskProfile == null || this.riskProfile.getCategories() == null || this.riskProfile.getCategories().getVULNERABILITY() == null) {
            return null;
        }
        return this.riskProfile.getCategories().getVULNERABILITY();
    }

    public RiskCounts getActivityRisk() {
        if (this.riskProfile == null || this.riskProfile.getCategories() == null || this.riskProfile.getCategories().getACTIVITY() == null) {
            return null;
        }
        return this.riskProfile.getCategories().getACTIVITY();
    }

    public RiskCounts getVersionRisk() {
        if (this.riskProfile == null || this.riskProfile.getCategories() == null || this.riskProfile.getCategories().getVERSION() == null) {
            return null;
        }
        return this.riskProfile.getCategories().getVERSION();
    }

    public RiskCounts getLicenseRisk() {
        if (this.riskProfile == null || this.riskProfile.getCategories() == null || this.riskProfile.getCategories().getLICENSE() == null) {
            return null;
        }
        return this.riskProfile.getCategories().getLICENSE();
    }

    public String getLicenseRiskString() {
        if (this.getLicenseRisk() == null) {
            return "";
        }
        if (this.getLicenseRisk().getHIGH() != 0) {
            return "H";
        }
        if (this.getLicenseRisk().getMEDIUM() != 0) {
            return "M";
        }
        if (this.getLicenseRisk().getLOW() != 0) {
            return "L";
        }
        return "-";
    }

    public RiskCounts getOperationalRisk() {
        if (this.riskProfile == null || this.riskProfile.getCategories() == null || this.riskProfile.getCategories().getOPERATIONAL() == null) {
            return null;
        }
        return this.riskProfile.getCategories().getOPERATIONAL();
    }

    public String getOperationalRiskString() {
        if (this.getOperationalRisk() == null) {
            return "";
        }
        if (this.getOperationalRisk().getHIGH() != 0) {
            return "H";
        }
        if (this.getOperationalRisk().getMEDIUM() != 0) {
            return "M";
        }
        if (this.getOperationalRisk().getLOW() != 0) {
            return "L";
        }
        return "-";
    }

    public DateTime getSinceTime() {
        if (StringUtils.isBlank(this.since)) {
            return null;
        }
        try {
            return new DateTime((Object)this.since);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public ProjectData getProducerProject() {
        return this.producerProject;
    }

    public List<ReleaseData> getProducerReleases() {
        return this.producerReleases;
    }

    public String getProducerReleasesId() {
        if (this.producerReleases == null || this.producerReleases.isEmpty()) {
            return "";
        }
        return this.producerReleases.get(0).getId();
    }

    public String getProducerReleasesDisplay() {
        if (this.producerReleases == null || this.producerReleases.isEmpty()) {
            return "";
        }
        return this.producerReleases.get(0).getVersion();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bomEntryIds == null ? 0 : this.bomEntryIds.hashCode());
        result = 31 * result + (this.bomViewEntryIds == null ? 0 : this.bomViewEntryIds.hashCode());
        result = 31 * result + (this.componentMatchTypes == null ? 0 : this.componentMatchTypes.hashCode());
        result = 31 * result + (this.createdByUsers == null ? 0 : this.createdByUsers.hashCode());
        result = 31 * result + (this.inUses == null ? 0 : this.inUses.hashCode());
        result = 31 * result + (this.licenses == null ? 0 : this.licenses.hashCode());
        result = 31 * result + (this.matchTypes == null ? 0 : this.matchTypes.hashCode());
        result = 31 * result + (this.policyApprovalStatus == null ? 0 : this.policyApprovalStatus.hashCode());
        result = 31 * result + (this.producerMatchTypes == null ? 0 : this.producerMatchTypes.hashCode());
        result = 31 * result + (this.producerProject == null ? 0 : this.producerProject.hashCode());
        result = 31 * result + (this.producerReleases == null ? 0 : this.producerReleases.hashCode());
        result = 31 * result + (this.riskProfile == null ? 0 : this.riskProfile.hashCode());
        result = 31 * result + (this.since == null ? 0 : this.since.hashCode());
        result = 31 * result + (this.usages == null ? 0 : this.usages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateBomViewEntry)) {
            return false;
        }
        AggregateBomViewEntry other = (AggregateBomViewEntry)obj;
        if (this.bomEntryIds == null ? other.bomEntryIds != null : !this.bomEntryIds.equals(other.bomEntryIds)) {
            return false;
        }
        if (this.bomViewEntryIds == null ? other.bomViewEntryIds != null : !this.bomViewEntryIds.equals(other.bomViewEntryIds)) {
            return false;
        }
        if (this.componentMatchTypes == null ? other.componentMatchTypes != null : !this.componentMatchTypes.equals(other.componentMatchTypes)) {
            return false;
        }
        if (this.createdByUsers == null ? other.createdByUsers != null : !this.createdByUsers.equals(other.createdByUsers)) {
            return false;
        }
        if (this.inUses == null ? other.inUses != null : !this.inUses.equals(other.inUses)) {
            return false;
        }
        if (this.licenses == null ? other.licenses != null : !this.licenses.equals(other.licenses)) {
            return false;
        }
        if (this.matchTypes == null ? other.matchTypes != null : !this.matchTypes.equals(other.matchTypes)) {
            return false;
        }
        if (this.policyApprovalStatus == null ? other.policyApprovalStatus != null : !this.policyApprovalStatus.equals(other.policyApprovalStatus)) {
            return false;
        }
        if (this.producerMatchTypes == null ? other.producerMatchTypes != null : !this.producerMatchTypes.equals(other.producerMatchTypes)) {
            return false;
        }
        if (this.producerProject == null ? other.producerProject != null : !this.producerProject.equals(other.producerProject)) {
            return false;
        }
        if (this.producerReleases == null ? other.producerReleases != null : !this.producerReleases.equals(other.producerReleases)) {
            return false;
        }
        if (this.riskProfile == null ? other.riskProfile != null : !this.riskProfile.equals(other.riskProfile)) {
            return false;
        }
        if (this.since == null ? other.since != null : !this.since.equals(other.since)) {
            return false;
        }
        return !(this.usages == null ? other.usages != null : !this.usages.equals(other.usages));
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, RecursiveToStringStyle.JSON_STYLE);
    }
}

