/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.group;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.exception.DoesNotExistException;
import com.blackducksoftware.integration.hub.model.view.UserGroupView;
import com.blackducksoftware.integration.hub.model.view.UserView;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import java.util.List;

public class GroupService
extends HubService {
    public GroupService(RestConnection restConnection) {
        super(restConnection);
    }

    public List<UserGroupView> getAllGroups() throws IntegrationException {
        return this.getAllViewsFromApi("usergroups", UserGroupView.class);
    }

    public UserGroupView getGroupByName(String groupName) throws IntegrationException {
        List<UserGroupView> allGroups = this.getAllGroups();
        for (UserGroupView group : allGroups) {
            if (!group.name.equalsIgnoreCase(groupName)) continue;
            return group;
        }
        throw new DoesNotExistException("This Group does not exist. Group name : " + groupName);
    }

    public List<UserView> getAllUsersForGroup(UserGroupView userGroupView) throws IntegrationException {
        return this.getAllViewsFromLink(userGroupView, "users", UserView.class);
    }
}

