class Risk(object):
    def __init__(self, value, threshold):
        self.__value = value
        self.__threshold = threshold

    def validate(self):
        if self.__threshold is None or self.__value is None or self.__value <= self.__threshold:
            return True
        else:
            return False

    def get_value(self):
        return self.__value

    def get_display_text(self):
        return "{0} ( {1} )".format("Pass" if self.validate() else "Fail", self.get_value())


class RiskProfile(object):
    def __init__(self, display_name, risk_high, risk_medium, risk_low, risk_none):
        self.__display_name = display_name
        self.__risk_high = risk_high
        self.__risk_medium = risk_medium
        self.__risk_low = risk_low
        self.__risk_none = risk_none

    def validate(self):
        return self.__risk_high.validate() and self.__risk_medium.validate() and self.__risk_low.validate()

    def pretty_print(self):
        print "|{0}|{1}|{2}|{3}|{4}|".format(self.__display_name, self.__risk_high.get_display_text(),
                                             self.__risk_medium.get_display_text(), self.__risk_low.get_display_text(),
                                             self.__risk_none.get_display_text())
