from com.xebialabs.xlrelease.plugin.blackduck import RestConnectionHelper
from com.blackducksoftware.integration.hub.api.view import MetaHandler
from com.blackducksoftware.integration.hub.model.view import RiskProfileView



class HubServicesHelper:
    def __init__(self, params):
        self.__server_params = params

    def get_hub_services_factory(self):
        connection_helper = RestConnectionHelper(self.__server_params['url'], self.__server_params['username'],
                                                 self.__server_params['password'],
                                                 self.__server_params['proxyHost'], self.__server_params['proxyPort'],
                                                 self.__server_params['proxyUsername'],
                                                 self.__server_params['proxyPassword'], self.__server_params['trustCertificate'])
        hub_services_factory = connection_helper.createHubServicesFactory()
        return hub_services_factory

    def get_risk_profile(self, project_name, version):
        hub_services_factory = self.get_hub_services_factory()
        project_version_service = hub_services_factory.createProjectVersionService()
        project_service = hub_services_factory.createProjectService()
        project_view = project_service.getProjectByName(project_name)
        version_view = project_version_service.getProjectVersion(project_view, version)
        risk_profile_view = project_version_service.getViewFromLink(version_view, MetaHandler.RISK_PROFILE_LINK,
                                                                    RiskProfileView)
        return risk_profile_view, project_view, version_view

