/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.util.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ProxyUtil {
    public static boolean shouldIgnoreHost(String hostToMatch, List<Pattern> ignoredProxyHostPatterns) {
        if (StringUtils.isBlank(hostToMatch) || ignoredProxyHostPatterns == null || ignoredProxyHostPatterns.isEmpty()) {
            return false;
        }
        for (Pattern ignoredProxyHostPattern : ignoredProxyHostPatterns) {
            Matcher m = ignoredProxyHostPattern.matcher(hostToMatch);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    public static List<Pattern> getIgnoredProxyHostPatterns(String ignoredProxyHosts) {
        ArrayList<Pattern> ignoredProxyHostPatterns = new ArrayList<Pattern>();
        if (StringUtils.isNotBlank(ignoredProxyHosts)) {
            String[] ignoreHosts = null;
            if (ignoredProxyHosts.contains(",")) {
                for (String ignoreHost : ignoreHosts = ignoredProxyHosts.split(",")) {
                    Pattern pattern = Pattern.compile(ignoreHost.trim());
                    ignoredProxyHostPatterns.add(pattern);
                }
            } else {
                Pattern pattern = Pattern.compile(ignoredProxyHosts);
                ignoredProxyHostPatterns.add(pattern);
            }
        }
        return ignoredProxyHostPatterns;
    }
}

