/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.validator;

import com.blackducksoftware.integration.hub.proxy.ProxyInfoFieldEnum;
import com.blackducksoftware.integration.validator.AbstractValidator;
import com.blackducksoftware.integration.validator.ValidationResult;
import com.blackducksoftware.integration.validator.ValidationResultEnum;
import com.blackducksoftware.integration.validator.ValidationResults;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;

public class ProxyInfoValidator
extends AbstractValidator {
    public static final String MSG_PROXY_INVALID_CONFIG = "The proxy information not valid - please check the log for the specific issues.";
    public static final String MSG_IGNORE_HOSTS_INVALID = "Proxy ignore hosts does not compile to a valid regular expression.";
    public static final String MSG_CREDENTIALS_INVALID = "Proxy username and password must both be populated or both be empty.";
    public static final String MSG_PROXY_PORT_INVALID = "Proxy port must be greater than 0.";
    public static final String MSG_PROXY_HOST_REQUIRED = "Proxy port specified, but proxy host not specified.";
    public static final String MSG_PROXY_PORT_REQUIRED = "Proxy host specified, but proxy port not specified.";
    public static final String MSG_PROXY_HOST_NOT_SPECIFIED = "Proxy host not specified.";
    private String host;
    private String port;
    private String username;
    private String password;
    private int passwordLength;
    private String ignoredProxyHosts;

    @Override
    public ValidationResults assertValid() {
        ValidationResults result = new ValidationResults();
        if (this.hasProxySettings()) {
            this.validatePort(result);
            this.validateCredentials(result);
            this.validateIgnoreHosts(result);
        }
        return result;
    }

    public void validatePort(ValidationResults result) {
        if (StringUtils.isBlank(this.host) && StringUtils.isBlank(this.port)) {
            return;
        }
        if (StringUtils.isBlank(this.host) && StringUtils.isNotBlank(this.port)) {
            result.addResult(ProxyInfoFieldEnum.PROXYHOST, new ValidationResult(ValidationResultEnum.ERROR, MSG_PROXY_HOST_REQUIRED));
        } else if (StringUtils.isNotBlank(this.host) && StringUtils.isBlank(this.port)) {
            result.addResult(ProxyInfoFieldEnum.PROXYPORT, new ValidationResult(ValidationResultEnum.ERROR, MSG_PROXY_PORT_REQUIRED));
            return;
        }
        int portToValidate = 0;
        try {
            portToValidate = this.stringToInteger(this.port);
        }
        catch (IllegalArgumentException e) {
            result.addResult(ProxyInfoFieldEnum.PROXYPORT, new ValidationResult(ValidationResultEnum.ERROR, e.getMessage(), e));
            return;
        }
        if (StringUtils.isNotBlank(this.host) && portToValidate < 0) {
            result.addResult(ProxyInfoFieldEnum.PROXYPORT, new ValidationResult(ValidationResultEnum.ERROR, MSG_PROXY_PORT_INVALID));
        }
    }

    public void validateCredentials(ValidationResults result) {
        if (StringUtils.isNotBlank(this.username) && StringUtils.isNotBlank(this.password) && StringUtils.isBlank(this.host)) {
            result.addResult(ProxyInfoFieldEnum.PROXYHOST, new ValidationResult(ValidationResultEnum.ERROR, MSG_PROXY_HOST_NOT_SPECIFIED));
        }
        if (StringUtils.isNotBlank(this.username) && StringUtils.isBlank(this.password) || StringUtils.isBlank(this.username) && StringUtils.isNotBlank(this.password)) {
            result.addResult(ProxyInfoFieldEnum.PROXYUSERNAME, new ValidationResult(ValidationResultEnum.ERROR, MSG_CREDENTIALS_INVALID));
            result.addResult(ProxyInfoFieldEnum.PROXYPASSWORD, new ValidationResult(ValidationResultEnum.ERROR, MSG_CREDENTIALS_INVALID));
        }
    }

    public void validateIgnoreHosts(ValidationResults result) {
        if (StringUtils.isNotBlank(this.ignoredProxyHosts)) {
            if (StringUtils.isBlank(this.host)) {
                result.addResult(ProxyInfoFieldEnum.PROXYHOST, new ValidationResult(ValidationResultEnum.ERROR, MSG_PROXY_HOST_NOT_SPECIFIED));
            }
            try {
                if (this.ignoredProxyHosts.contains(",")) {
                    String[] ignoreHosts = null;
                    for (String ignoreHost : ignoreHosts = this.ignoredProxyHosts.split(",")) {
                        Pattern.compile(ignoreHost.trim());
                    }
                } else {
                    Pattern.compile(this.ignoredProxyHosts);
                }
            }
            catch (PatternSyntaxException ex) {
                result.addResult(ProxyInfoFieldEnum.NOPROXYHOSTS, new ValidationResult(ValidationResultEnum.ERROR, MSG_IGNORE_HOSTS_INVALID));
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.setPort(String.valueOf(port));
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public void setPasswordLength(int passwordLength) {
        this.passwordLength = passwordLength;
    }

    public String getIgnoredProxyHosts() {
        return this.ignoredProxyHosts;
    }

    public void setIgnoredProxyHosts(String ignoredProxyHosts) {
        this.ignoredProxyHosts = ignoredProxyHosts;
    }

    public boolean hasProxySettings() {
        return StringUtils.isNotBlank(this.host) || StringUtils.isNotBlank(this.port) && !"0".equals(this.port) || StringUtils.isNotBlank(this.username) || StringUtils.isNotBlank(this.password) || StringUtils.isNotBlank(this.ignoredProxyHosts);
    }

    public boolean hasAuthenticatedProxySettings() {
        return StringUtils.isNotBlank(this.password) && StringUtils.isNotBlank(this.username);
    }
}

