/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.component;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.aggregate.bom.AggregateBomService;
import com.blackducksoftware.integration.hub.api.component.ComponentService;
import com.blackducksoftware.integration.hub.api.matchedfiles.MatchedFilesService;
import com.blackducksoftware.integration.hub.api.project.ProjectService;
import com.blackducksoftware.integration.hub.api.project.version.ProjectVersionService;
import com.blackducksoftware.integration.hub.api.view.MetaHandler;
import com.blackducksoftware.integration.hub.bdio.model.externalid.ExternalId;
import com.blackducksoftware.integration.hub.dataservice.component.model.VersionBomComponentModel;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.model.view.ComponentSearchResultView;
import com.blackducksoftware.integration.hub.model.view.ComponentVersionView;
import com.blackducksoftware.integration.hub.model.view.ComponentView;
import com.blackducksoftware.integration.hub.model.view.MatchedFilesView;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.model.view.ProjectView;
import com.blackducksoftware.integration.hub.model.view.VersionBomComponentView;
import com.blackducksoftware.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.List;

public class ComponentDataService {
    private final IntLogger logger;
    private final ProjectService projectRequestService;
    private final ProjectVersionService projectVersionRequestService;
    private final ComponentService componentRequestService;
    private final AggregateBomService aggregateBomService;
    private final MatchedFilesService matchedFilesService;
    private final MetaHandler metaHandler;

    public ComponentDataService(IntLogger logger, ProjectService projectRequestService, ProjectVersionService projectVersionRequestService, ComponentService componentRequestService, AggregateBomService aggregateBomService, MatchedFilesService matchedFilesService) {
        this.logger = logger;
        this.projectRequestService = projectRequestService;
        this.projectVersionRequestService = projectVersionRequestService;
        this.componentRequestService = componentRequestService;
        this.aggregateBomService = aggregateBomService;
        this.matchedFilesService = matchedFilesService;
        this.metaHandler = new MetaHandler(logger);
    }

    public ComponentVersionView getExactComponentVersionFromComponent(ExternalId externalId) throws IntegrationException {
        for (ComponentVersionView componentVersion : this.getAllComponentVersionsFromComponent(externalId)) {
            if (!componentVersion.versionName.equals(externalId.version)) continue;
            return componentVersion;
        }
        String errMsg = "Could not find version " + externalId.version + " of component " + externalId.createHubOriginId();
        this.logger.error(errMsg);
        throw new HubIntegrationException(errMsg);
    }

    public List<ComponentVersionView> getAllComponentVersionsFromComponent(ExternalId externalId) throws IntegrationException {
        ComponentSearchResultView componentSearchView = this.componentRequestService.getExactComponentMatch(externalId);
        ComponentView componentView = this.componentRequestService.getView(componentSearchView.componentUrl, ComponentView.class);
        List<ComponentVersionView> componentVersionViews = this.componentRequestService.getAllViewsFromLink(componentView, "versions", ComponentVersionView.class);
        return componentVersionViews;
    }

    public void addComponentToProjectVersion(ExternalId componentExternalId, String projectName, String projectVersionName) throws IntegrationException {
        ProjectView projectView = this.projectRequestService.getProjectByName(projectName);
        ProjectVersionView projectVersionView = this.projectVersionRequestService.getProjectVersion(projectView, projectVersionName);
        String projectVersionComponentsUrl = this.projectVersionRequestService.getFirstLink(projectVersionView, "components");
        ComponentSearchResultView componentSearchResultView = this.componentRequestService.getExactComponentMatch(componentExternalId);
        String componentVersionUrl = componentSearchResultView.componentVersionUrl;
        this.aggregateBomService.addBomComponent("application/json", projectVersionComponentsUrl, componentVersionUrl);
    }

    public List<VersionBomComponentView> getAllComponentVersionsFromProjectVersion(String projectName, String projectVersionName) throws IntegrationException {
        ProjectView projectItem = this.projectRequestService.getProjectByName(projectName);
        ProjectVersionView projectVersionView = this.projectVersionRequestService.getProjectVersion(projectItem, projectVersionName);
        List<VersionBomComponentView> versionBomComponentViews = this.projectVersionRequestService.getAllViewsFromLink(projectVersionView, "components", VersionBomComponentView.class);
        return versionBomComponentViews;
    }

    public List<VersionBomComponentModel> getComponentsForProjectVersion(String projectName, String projectVersionName) throws IntegrationException {
        ProjectView project = this.projectRequestService.getProjectByName(projectName);
        ProjectVersionView version = this.projectVersionRequestService.getProjectVersion(project, projectVersionName);
        return this.getComponentsForProjectVersion(version);
    }

    public List<VersionBomComponentModel> getComponentsForProjectVersion(ProjectVersionView version) throws IntegrationException {
        List<VersionBomComponentView> bomComponents = this.aggregateBomService.getBomEntries(version);
        ArrayList<VersionBomComponentModel> modelBomComponents = new ArrayList<VersionBomComponentModel>(bomComponents.size());
        for (VersionBomComponentView component : bomComponents) {
            modelBomComponents.add(new VersionBomComponentModel(component, this.getMatchedFiles(component)));
        }
        return modelBomComponents;
    }

    private List<MatchedFilesView> getMatchedFiles(VersionBomComponentView component) {
        try {
            String matchedFilesLink = this.metaHandler.getFirstLink(component, "matched-files");
            return this.matchedFilesService.getMatchedFiles(matchedFilesLink);
        }
        catch (IntegrationException e) {
            return new ArrayList<MatchedFilesView>(0);
        }
    }
}

