/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.cli;

import com.blackducksoftware.integration.exception.EncryptionException;
import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.HubSupportHelper;
import com.blackducksoftware.integration.hub.api.codelocation.CodeLocationService;
import com.blackducksoftware.integration.hub.api.nonpublic.HubVersionService;
import com.blackducksoftware.integration.hub.api.project.ProjectService;
import com.blackducksoftware.integration.hub.api.project.version.ProjectVersionService;
import com.blackducksoftware.integration.hub.api.scan.ScanSummaryService;
import com.blackducksoftware.integration.hub.api.view.MetaHandler;
import com.blackducksoftware.integration.hub.builder.HubScanConfigBuilder;
import com.blackducksoftware.integration.hub.cli.CLIDownloadUtility;
import com.blackducksoftware.integration.hub.cli.SimpleScanUtility;
import com.blackducksoftware.integration.hub.dataservice.phonehome.PhoneHomeDataService;
import com.blackducksoftware.integration.hub.dataservice.scan.ScanStatusDataService;
import com.blackducksoftware.integration.hub.exception.DoesNotExistException;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.global.HubServerConfig;
import com.blackducksoftware.integration.hub.model.request.ProjectRequest;
import com.blackducksoftware.integration.hub.model.view.CodeLocationView;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.model.view.ProjectView;
import com.blackducksoftware.integration.hub.model.view.ScanSummaryView;
import com.blackducksoftware.integration.hub.scan.HubScanConfig;
import com.blackducksoftware.integration.hub.util.HostnameHelper;
import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.phonehome.PhoneHomeRequestBodyBuilder;
import com.blackducksoftware.integration.phonehome.enums.ThirdPartyName;
import com.blackducksoftware.integration.util.CIEnvironmentVariables;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class CLIDataService {
    private final Gson gson;
    private final IntLogger logger;
    private final CIEnvironmentVariables ciEnvironmentVariables;
    private final HubVersionService hubVersionRequestService;
    private final CLIDownloadUtility cliDownloadService;
    private final PhoneHomeDataService phoneHomeDataService;
    private final ProjectService projectRequestService;
    private final ProjectVersionService projectVersionRequestService;
    private final CodeLocationService codeLocationRequestService;
    private final ScanSummaryService scanSummaryRequestService;
    private final ScanStatusDataService scanStatusDataService;
    private final MetaHandler metaService;
    private HubSupportHelper hubSupportHelper;
    private ProjectVersionView version;

    public CLIDataService(IntLogger logger, Gson gson, CIEnvironmentVariables ciEnvironmentVariables, HubVersionService hubVersionRequestService, CLIDownloadUtility cliDownloadService, PhoneHomeDataService phoneHomeDataService, ProjectService projectRequestService, ProjectVersionService projectVersionRequestService, CodeLocationService codeLocationRequestService, ScanSummaryService scanSummaryRequestService, ScanStatusDataService scanStatusDataService) {
        this.gson = gson;
        this.logger = logger;
        this.ciEnvironmentVariables = ciEnvironmentVariables;
        this.hubVersionRequestService = hubVersionRequestService;
        this.cliDownloadService = cliDownloadService;
        this.phoneHomeDataService = phoneHomeDataService;
        this.projectRequestService = projectRequestService;
        this.projectVersionRequestService = projectVersionRequestService;
        this.codeLocationRequestService = codeLocationRequestService;
        this.scanSummaryRequestService = scanSummaryRequestService;
        this.scanStatusDataService = scanStatusDataService;
        this.metaService = new MetaHandler(logger);
    }

    public ProjectVersionView installAndRunControlledScan(HubServerConfig hubServerConfig, HubScanConfig hubScanConfig, ProjectRequest projectRequest, boolean shouldWaitForScansFinished, ThirdPartyName thirdPartyName, String thirdPartyVersion, String pluginVersion) throws IntegrationException {
        return this.installAndRunControlledScan(hubServerConfig, hubScanConfig, projectRequest, shouldWaitForScansFinished, thirdPartyName.getName(), thirdPartyVersion, pluginVersion);
    }

    public ProjectVersionView installAndRunControlledScan(HubServerConfig hubServerConfig, HubScanConfig hubScanConfig, ProjectRequest projectRequest, boolean shouldWaitForScansFinished, String thirdPartyName, String thirdPartyVersion, String pluginVersion) throws IntegrationException {
        PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder = null;
        try {
            phoneHomeRequestBodyBuilder = this.phoneHomeDataService.createInitialPhoneHomeRequestBodyBuilder(thirdPartyName, thirdPartyVersion, pluginVersion);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
        }
        this.preScan(hubServerConfig, hubScanConfig, projectRequest, phoneHomeRequestBodyBuilder);
        SimpleScanUtility simpleScanService = this.createScanService(hubServerConfig, hubScanConfig, projectRequest);
        File[] scanSummaryFiles = this.runScan(simpleScanService);
        this.postScan(hubScanConfig, scanSummaryFiles, projectRequest, shouldWaitForScansFinished, simpleScanService);
        return this.version;
    }

    private SimpleScanUtility createScanService(HubServerConfig hubServerConfig, HubScanConfig hubScanConfig, ProjectRequest projectRequest) {
        HubScanConfig controlledConfig = this.getControlledScanConfig(hubScanConfig);
        if (hubScanConfig.isDryRun()) {
            return new SimpleScanUtility(this.logger, this.gson, hubServerConfig, this.hubSupportHelper, this.ciEnvironmentVariables, controlledConfig, projectRequest.getName(), projectRequest.getVersionRequest().getVersionName());
        }
        return new SimpleScanUtility(this.logger, this.gson, hubServerConfig, this.hubSupportHelper, this.ciEnvironmentVariables, controlledConfig, null, null);
    }

    public File[] runControlledScan(HubServerConfig hubServerConfig, HubScanConfig hubScanConfig, ProjectRequest projectRequest) throws IntegrationException {
        SimpleScanUtility simpleScanService = this.createScanService(hubServerConfig, hubScanConfig, projectRequest);
        File[] scanSummaryFiles = this.runScan(simpleScanService);
        if (hubScanConfig.isCleanupLogsOnSuccess()) {
            this.cleanUpLogFiles(simpleScanService);
        }
        return scanSummaryFiles;
    }

    private File[] runScan(SimpleScanUtility simpleScanService) throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        simpleScanService.setupAndExecuteScan();
        File[] scanSummaryFiles = simpleScanService.getScanSummaryFiles();
        return scanSummaryFiles;
    }

    private void printConfiguration(HubScanConfig hubScanConfig, ProjectRequest projectRequest) {
        this.logger.alwaysLog(String.format("--> Log Level : %s", this.logger.getLogLevel().name()));
        String projectName = null;
        String projectVersionName = null;
        String projectVersionPhase = null;
        String projectVersionDistribution = null;
        if (projectRequest != null) {
            projectName = projectRequest.getName();
            if (projectRequest.getVersionRequest() != null) {
                projectVersionName = projectRequest.getVersionRequest().getVersionName();
                projectVersionPhase = projectRequest.getVersionRequest().getPhase() == null ? null : projectRequest.getVersionRequest().getPhase().toString();
                projectVersionDistribution = projectRequest.getVersionRequest().getDistribution() == null ? null : projectRequest.getVersionRequest().getDistribution().toString();
            }
        }
        this.logger.alwaysLog(String.format("--> Using Hub Project Name : %s, Version : %s, Phase : %s, Distribution : %s", projectName, projectVersionName, projectVersionPhase, projectVersionDistribution));
        hubScanConfig.print(this.logger);
    }

    private void preScan(HubServerConfig hubServerConfig, HubScanConfig hubScanConfig, ProjectRequest projectRequest, PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder) throws IntegrationException {
        String localHostName = HostnameHelper.getMyHostname();
        this.logger.info("Running on machine : " + localHostName);
        this.printConfiguration(hubScanConfig, projectRequest);
        String hubVersion = this.hubVersionRequestService.getHubVersion();
        this.cliDownloadService.performInstallation(hubScanConfig.getToolsDir(), this.ciEnvironmentVariables, hubServerConfig.getHubUrl().toString(), hubVersion, localHostName);
        this.phoneHomeDataService.phoneHome(phoneHomeRequestBodyBuilder);
        this.hubSupportHelper = new HubSupportHelper();
        this.hubSupportHelper.checkHubSupport(this.hubVersionRequestService, this.logger);
        if (!hubScanConfig.isDryRun()) {
            this.getProjectVersion(projectRequest);
        }
    }

    private void postScan(HubScanConfig hubScanConfig, File[] scanSummaryFiles, ProjectRequest projectRequest, boolean shouldWaitForScansFinished, SimpleScanUtility simpleScanService) throws IntegrationException {
        this.logger.trace("Scan is dry run ${hubScanConfig.isDryRun()}");
        if (hubScanConfig.isCleanupLogsOnSuccess()) {
            this.cleanUpLogFiles(simpleScanService);
        }
        if (!hubScanConfig.isDryRun()) {
            ArrayList<CodeLocationView> codeLocationViews = new ArrayList<CodeLocationView>();
            ArrayList<ScanSummaryView> scanSummaries = new ArrayList<ScanSummaryView>();
            this.logger.trace("Found ${scanSummaryFiles.length} scan summary files");
            for (File scanSummaryFile : scanSummaryFiles) {
                try {
                    ScanSummaryView scanSummary = this.getScanSummaryFromFile(scanSummaryFile);
                    scanSummaries.add(scanSummary);
                    scanSummaryFile.delete();
                    String codeLocationUrl = this.metaService.getFirstLinkSafely(scanSummary, "codelocation");
                    CodeLocationView codeLocationView = this.codeLocationRequestService.getView(codeLocationUrl, CodeLocationView.class);
                    codeLocationViews.add(codeLocationView);
                    this.codeLocationRequestService.mapCodeLocation(codeLocationView, this.version);
                }
                catch (IOException ex) {
                    this.logger.trace("Error reading scan summary file", ex);
                }
            }
            simpleScanService.getStatusDirectory().delete();
            this.cleanupCodeLocations(codeLocationViews, hubScanConfig);
            if (shouldWaitForScansFinished) {
                this.logger.debug("Waiting for the Bom to be updated.");
                this.scanStatusDataService.assertScansFinished(scanSummaries);
            }
        }
    }

    private ScanSummaryView getScanSummaryFromFile(File scanSummaryFile) throws IOException {
        String scanSummaryJson = FileUtils.readFileToString((File)scanSummaryFile, (Charset)Charset.forName("UTF8"));
        ScanSummaryView scanSummaryView = this.gson.fromJson(scanSummaryJson, ScanSummaryView.class);
        scanSummaryView.json = scanSummaryJson;
        return scanSummaryView;
    }

    private HubScanConfig getControlledScanConfig(HubScanConfig originalHubScanConfig) {
        HubScanConfigBuilder builder = new HubScanConfigBuilder();
        builder.setCodeLocationAlias(originalHubScanConfig.getCodeLocationAlias());
        builder.setVerbose(originalHubScanConfig.isVerbose());
        builder.setDryRun(originalHubScanConfig.isDryRun());
        builder.setExcludePatterns(originalHubScanConfig.getExcludePatterns());
        builder.setScanMemory(originalHubScanConfig.getScanMemory());
        builder.setToolsDir(originalHubScanConfig.getToolsDir());
        builder.setWorkingDirectory(originalHubScanConfig.getWorkingDirectory());
        builder.addAllScanTargetPaths(new ArrayList<String>(originalHubScanConfig.getScanTargetPaths()));
        return (HubScanConfig)builder.build();
    }

    private void cleanUpLogFiles(SimpleScanUtility simpleScanService) {
        File cliLogDirectory;
        File standardOutputFile = simpleScanService.getStandardOutputFile();
        if (standardOutputFile != null && standardOutputFile.exists()) {
            standardOutputFile.delete();
        }
        if ((cliLogDirectory = simpleScanService.getCLILogDirectory()) != null && cliLogDirectory.exists()) {
            for (File log : cliLogDirectory.listFiles()) {
                log.delete();
            }
            cliLogDirectory.delete();
        }
    }

    private void cleanupCodeLocations(List<CodeLocationView> codeLocationsFromCurentScan, HubScanConfig hubScanConfig) throws IntegrationException {
        if (hubScanConfig.isDeletePreviousCodeLocations() || hubScanConfig.isUnmapPreviousCodeLocations()) {
            List<CodeLocationView> codeLocationsNotJustScanned = this.getCodeLocationsNotJustScanned(this.version, codeLocationsFromCurentScan);
            if (hubScanConfig.isDeletePreviousCodeLocations()) {
                this.codeLocationRequestService.deleteCodeLocations(codeLocationsNotJustScanned);
            } else if (hubScanConfig.isUnmapPreviousCodeLocations()) {
                this.codeLocationRequestService.unmapCodeLocations(codeLocationsNotJustScanned);
            }
        }
    }

    private List<CodeLocationView> getCodeLocationsNotJustScanned(ProjectVersionView version, List<CodeLocationView> codeLocationsFromCurentScan) throws IntegrationException {
        List<CodeLocationView> codeLocationsMappedToVersion = this.codeLocationRequestService.getAllCodeLocationsForProjectVersion(version);
        return this.getCodeLocationsNotJustScanned(codeLocationsMappedToVersion, codeLocationsFromCurentScan);
    }

    private List<CodeLocationView> getCodeLocationsNotJustScanned(List<CodeLocationView> codeLocationsMappedToVersion, List<CodeLocationView> codeLocationsFromCurentScan) {
        ArrayList<CodeLocationView> codeLocationsNotJustScanned = new ArrayList<CodeLocationView>();
        for (CodeLocationView codeLocationItemMappedToVersion : codeLocationsMappedToVersion) {
            boolean partOfCurrentScan = false;
            for (CodeLocationView codeLocationFromCurentScan : codeLocationsFromCurentScan) {
                if (!codeLocationItemMappedToVersion.url.equals(codeLocationFromCurentScan.url)) continue;
                partOfCurrentScan = true;
                break;
            }
            if (partOfCurrentScan) continue;
            codeLocationsNotJustScanned.add(codeLocationItemMappedToVersion);
        }
        return codeLocationsNotJustScanned;
    }

    private void getProjectVersion(ProjectRequest projectRequest) throws IntegrationException {
        ProjectView project = null;
        try {
            project = this.projectRequestService.getProjectByName(projectRequest.getName());
        }
        catch (DoesNotExistException e) {
            String projectURL = this.projectRequestService.createHubProject(projectRequest);
            project = this.projectRequestService.getView(projectURL, ProjectView.class);
        }
        try {
            this.version = this.projectVersionRequestService.getProjectVersion(project, projectRequest.getVersionRequest().getVersionName());
        }
        catch (DoesNotExistException e) {
            String versionURL = this.projectVersionRequestService.createHubVersion(project, projectRequest.getVersionRequest());
            this.version = this.projectVersionRequestService.getView(versionURL, ProjectVersionView.class);
        }
    }

    private void cleanupScanSummaryFile(File scanSummaryFile) {
        scanSummaryFile.delete();
        File parentDirectory = scanSummaryFile.getParentFile();
        File[] fileList = parentDirectory.listFiles();
        if (fileList != null && fileList.length == 0) {
            parentDirectory.delete();
        }
    }
}

