/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.certificate;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.certificate.CertificateHandler;
import com.blackducksoftware.integration.hub.global.HubServerConfig;
import com.blackducksoftware.integration.log.IntLogger;
import java.io.File;

public class HubCertificateHandler {
    private final IntLogger logger;
    private final CertificateHandler handler;

    public HubCertificateHandler(IntLogger logger) {
        this.logger = logger;
        this.handler = new CertificateHandler(logger);
    }

    public HubCertificateHandler(IntLogger logger, File javaHomeOverride) {
        this.logger = logger;
        this.handler = new CertificateHandler(logger, javaHomeOverride);
    }

    public void importHttpsCertificateForHubServer(HubServerConfig hubServerConfig) throws IntegrationException {
        if (hubServerConfig == null || hubServerConfig.getHubUrl() == null || !hubServerConfig.getHubUrl().getProtocol().startsWith("https")) {
            return;
        }
        this.handler.timeout = hubServerConfig.getTimeout();
        if (hubServerConfig.getProxyInfo() != null) {
            this.handler.proxyHost = hubServerConfig.getProxyInfo().getHost();
            this.handler.proxyPort = hubServerConfig.getProxyInfo().getPort();
            this.handler.proxyNoHosts = hubServerConfig.getProxyInfo().getIgnoredProxyHosts();
            this.handler.proxyUsername = hubServerConfig.getProxyInfo().getUsername();
            this.handler.proxyPassword = hubServerConfig.getProxyInfo().getDecryptedPassword();
        }
        if (this.handler.isCertificateInTrustStore(hubServerConfig.getHubUrl())) {
            return;
        }
        this.handler.retrieveAndImportHttpsCertificate(hubServerConfig.getHubUrl());
    }
}

