from blackduck.task.helper.risk_profile import *
from blackduck.hub_services_helper import HubServicesHelper

if not blackduckServer:
    raise Exception("Blackduck server ID must be provided")

hub_services_helper = HubServicesHelper(params=blackduckServer)
hub_services_factory = hub_services_helper.get_hub_services_factory()
risk_report_data_service = hub_services_factory.createRiskReportDataService(20000)
rd = risk_report_data_service.getRiskReportData(projectName, versionName)

security_risk_profile = RiskProfile('Security Risk :',
                                    Risk(rd.getVulnerabilityRiskHighCount(), securityRiskHighThreshold),
                                    Risk(rd.getVulnerabilityRiskMediumCount(), securityRiskMediumThreshold),
                                    Risk(rd.getVulnerabilityRiskLowCount(), securityRiskLowThreshold),
                                    Risk(rd.getVulnerabilityRiskNoneCount(), None));

license_risk_profile = RiskProfile('License Risk :', Risk(rd.getLicenseRiskHighCount(), licenseRiskHighThreshold),
                                   Risk(rd.getLicenseRiskMediumCount(), licenseRiskMediumThreshold),
                                   Risk(rd.getLicenseRiskLowCount(), licenseRiskLowThreshold),
                                   Risk(rd.getLicenseRiskNoneCount(), None))

operational_risk_profile = RiskProfile('Operational Risk :',
                                       Risk(rd.getOperationalRiskHighCount(), operationalRiskHighThreshold),
                                       Risk(rd.getOperationalRiskMediumCount(), operationalRiskMediumThreshold),
                                       Risk(rd.getOperationalRiskLowCount(), operationalRiskLowThreshold),
                                       Risk(rd.getOperationalRiskNoneCount(), None))

print "|       |  High         |  Medium       |  Low | None |"
print "|-"
security_risk_profile.pretty_print()
license_risk_profile.pretty_print()
operational_risk_profile.pretty_print()

if not (security_risk_profile.validate() and license_risk_profile.validate() and operational_risk_profile.validate()):
    raise RuntimeError("Risks are not allowed")
