/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.rest.oauth;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.oauth.OAuthConfiguration;
import com.blackducksoftware.integration.hub.api.oauth.Token;
import com.blackducksoftware.integration.hub.proxy.ProxyInfo;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.rest.UnauthenticatedRestConnectionBuilder;
import com.blackducksoftware.integration.hub.rest.oauth.AccessType;
import com.blackducksoftware.integration.hub.service.HubOAuthTokenService;
import com.blackducksoftware.integration.log.IntLogger;
import java.net.MalformedURLException;
import org.apache.commons.lang3.StringUtils;

public class TokenManager {
    public static final String WWW_AUTH_RESP = "Authorization";
    private final IntLogger logger;
    private final int timeout;
    private OAuthConfiguration configuration;
    private Token clientToken;
    private ProxyInfo proxyInfo;
    private boolean alwaysTrustServerCertificate;

    public TokenManager(IntLogger logger, int timeout) {
        this(logger, timeout, ProxyInfo.NO_PROXY_INFO, false);
    }

    public TokenManager(IntLogger logger, int timeout, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate) {
        this.logger = logger;
        this.timeout = timeout;
        this.proxyInfo = proxyInfo;
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
    }

    public IntLogger getLogger() {
        return this.logger;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public OAuthConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAuthConfiguration configuration) {
        this.configuration = configuration;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public void setProxyInfo(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
    }

    public boolean isAlwaysTrustServerCertificate() {
        return this.alwaysTrustServerCertificate;
    }

    public void setAlwaysTrustServerCertificate(boolean alwaysTrustServerCertificate) {
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
    }

    public String createTokenCredential(String token) {
        return String.format("Bearer %s", token);
    }

    public Token exchangeForUserToken(String authorizationCode) throws IntegrationException {
        Token result = null;
        try {
            RestConnection connection = this.createConnection();
            HubOAuthTokenService tokenService = new HubOAuthTokenService(connection);
            result = tokenService.requestUserToken(this.configuration.clientId, authorizationCode, this.configuration.callbackUrl);
        }
        catch (IntegrationException | MalformedURLException ex) {
            throw new IntegrationException("Error refreshing client token", ex);
        }
        return result;
    }

    public Token refreshToken(AccessType accessType) throws IntegrationException {
        Token result = null;
        if (AccessType.USER.equals((Object)accessType)) {
            result = this.refreshUserAccessToken();
        } else if (AccessType.CLIENT.equals((Object)accessType)) {
            result = this.refreshClientAccessToken();
        }
        return result;
    }

    public Token getToken(AccessType accessType) throws IntegrationException {
        Token result = null;
        if (AccessType.USER.equals((Object)accessType)) {
            result = this.refreshUserAccessToken();
        } else if (AccessType.CLIENT.equals((Object)accessType)) {
            if (this.clientToken == null) {
                this.refreshClientAccessToken();
            }
            result = this.clientToken;
        }
        return result;
    }

    private Token refreshUserAccessToken() throws IntegrationException {
        Token result = null;
        if (StringUtils.isNotBlank(this.configuration.refreshToken)) {
            try {
                RestConnection connection = this.createConnection();
                HubOAuthTokenService tokenService = new HubOAuthTokenService(connection);
                result = tokenService.refreshUserToken(this.configuration.clientId, this.configuration.refreshToken);
            }
            catch (IntegrationException | MalformedURLException ex) {
                throw new IntegrationException("Error refreshing user token", ex);
            }
        } else {
            throw new IntegrationException("No token present to refresh");
        }
        return result;
    }

    private Token refreshClientAccessToken() throws IntegrationException {
        Token result = null;
        try {
            RestConnection connection = this.createConnection();
            HubOAuthTokenService tokenService = new HubOAuthTokenService(connection);
            this.clientToken = result = tokenService.refreshClientToken(this.configuration.clientId);
        }
        catch (IntegrationException | MalformedURLException ex) {
            throw new IntegrationException("Error refreshing client token", ex);
        }
        return result;
    }

    private RestConnection createConnection() throws MalformedURLException {
        UnauthenticatedRestConnectionBuilder connectionBuilder = new UnauthenticatedRestConnectionBuilder();
        connectionBuilder.setBaseUrl(this.configuration.tokenUri);
        connectionBuilder.setTimeout(this.timeout);
        connectionBuilder.setLogger(this.getLogger());
        connectionBuilder.setAlwaysTrustServerCertificate(this.alwaysTrustServerCertificate);
        connectionBuilder.applyProxyInfo(this.proxyInfo);
        RestConnection connection = (RestConnection)connectionBuilder.build();
        return connection;
    }
}

