/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.request;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class HubRequest {
    public final RestConnection restConnection;
    public String url;
    public final List<String> urlSegments = new ArrayList<String>();
    public final Map<String, String> queryParameters = new HashMap<String, String>();
    public String q;

    public HubRequest(RestConnection restConnection) {
        this.restConnection = restConnection;
    }

    public Response executeGet() throws IntegrationException {
        HttpUrl httpUrl = this.buildHttpUrl();
        Request request = this.restConnection.createGetRequest(httpUrl);
        return this.restConnection.createResponse(request);
    }

    public Response executeGet(String mediaType) throws IntegrationException {
        HttpUrl httpUrl = this.buildHttpUrl();
        Request request = this.restConnection.createGetRequest(httpUrl, mediaType);
        return this.restConnection.createResponse(request);
    }

    public Response executeEncodedFormPost(Map<String, String> contentMap) throws IntegrationException {
        HttpUrl httpUrl = this.buildHttpUrl();
        Request request = this.restConnection.createPostRequest(httpUrl, this.restConnection.createEncodedFormBody(contentMap));
        return this.restConnection.createResponse(request);
    }

    public Response executePost(String content) throws IntegrationException {
        HttpUrl httpUrl = this.buildHttpUrl();
        Request request = this.restConnection.createPostRequest(httpUrl, this.restConnection.createJsonRequestBody(content));
        return this.restConnection.createResponse(request);
    }

    public Response executePost(String mediaType, String content) throws IntegrationException {
        HttpUrl httpUrl = this.buildHttpUrl();
        Request request = this.restConnection.createPostRequest(httpUrl, this.restConnection.createJsonRequestBody(mediaType, content));
        return this.restConnection.createResponse(request);
    }

    public Response executePost(String mediaType, File file) throws IntegrationException {
        HttpUrl httpUrl = this.buildHttpUrl();
        Request request = this.restConnection.createPostRequest(httpUrl, this.restConnection.createFileRequestBody(mediaType, file));
        return this.restConnection.createResponse(request);
    }

    public Response executeEncodedFormPut(Map<String, String> contentMap) throws IntegrationException {
        HttpUrl httpUrl = this.buildHttpUrl();
        Request request = this.restConnection.createPutRequest(httpUrl, this.restConnection.createEncodedFormBody(contentMap));
        return this.restConnection.createResponse(request);
    }

    public Response executePut(String content) throws IntegrationException {
        HttpUrl httpUrl = this.buildHttpUrl();
        Request request = this.restConnection.createPutRequest(httpUrl, this.restConnection.createJsonRequestBody(content));
        return this.restConnection.createResponse(request);
    }

    public Response executePut(String mediaType, String content) throws IntegrationException {
        HttpUrl httpUrl = this.buildHttpUrl();
        Request request = this.restConnection.createPutRequest(httpUrl, this.restConnection.createJsonRequestBody(mediaType, content));
        return this.restConnection.createResponse(request);
    }

    public void executeDelete() throws IntegrationException {
        HttpUrl httpUrl = this.buildHttpUrl();
        Request request = this.restConnection.createDeleteRequest(httpUrl);
        Response response = this.restConnection.createResponse(request);
        Throwable throwable = null;
        if (response != null) {
            if (throwable != null) {
                try {
                    response.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                response.close();
            }
        }
    }

    protected void populateQueryParameters() {
        if (StringUtils.isNotBlank(this.q)) {
            this.queryParameters.put("q", this.q);
        }
    }

    private HttpUrl buildHttpUrl() {
        this.populateQueryParameters();
        if (StringUtils.isBlank(this.url)) {
            this.url = this.restConnection.hubBaseUrl.toString();
        }
        return this.restConnection.createHttpUrl(this.url, this.urlSegments, this.queryParameters);
    }

    public void addUrlSegment(String urlSegment) {
        this.urlSegments.add(urlSegment);
    }

    public void addUrlSegments(List<String> urlSegment) {
        this.urlSegments.addAll(urlSegment);
    }

    public HubRequest addQueryParameter(String queryParameterName, String queryParameterValue) {
        this.queryParameters.put(queryParameterName, queryParameterValue);
        return this;
    }

    public HubRequest addQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters.putAll(queryParameters);
        return this;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, RecursiveToStringStyle.JSON_STYLE);
    }
}

