/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.policystatus;

import com.blackducksoftware.integration.hub.model.enumeration.PolicySeverityEnum;
import com.blackducksoftware.integration.hub.model.enumeration.VersionBomPolicyStatusOverallStatusEnum;
import com.blackducksoftware.integration.hub.model.view.VersionBomPolicyStatusView;
import com.blackducksoftware.integration.hub.model.view.components.ComponentVersionPolicyViolationCount;
import com.blackducksoftware.integration.hub.model.view.components.ComponentVersionPolicyViolationDetails;
import com.blackducksoftware.integration.hub.model.view.components.ComponentVersionStatusCount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PolicyStatusDescription {
    private final VersionBomPolicyStatusView policyStatusItem;
    private final Map<VersionBomPolicyStatusOverallStatusEnum, ComponentVersionStatusCount> policyStatusCount = new HashMap<VersionBomPolicyStatusOverallStatusEnum, ComponentVersionStatusCount>();
    private final Map<PolicySeverityEnum, ComponentVersionPolicyViolationCount> policySeverityCount = new HashMap<PolicySeverityEnum, ComponentVersionPolicyViolationCount>();

    public PolicyStatusDescription(VersionBomPolicyStatusView policyStatusItem) {
        this.policyStatusItem = policyStatusItem;
        this.populatePolicySeverityMap();
        this.populatePolicyStatusMap();
    }

    private void populatePolicySeverityMap() {
        ComponentVersionPolicyViolationDetails policyViolationDetails = this.policyStatusItem.componentVersionPolicyViolationDetails;
        if (policyViolationDetails != null && VersionBomPolicyStatusOverallStatusEnum.IN_VIOLATION.equals((Object)this.policyStatusItem.overallStatus)) {
            List<ComponentVersionPolicyViolationCount> severityLevels = policyViolationDetails.severityLevels;
            if (policyViolationDetails.severityLevels != null) {
                for (ComponentVersionPolicyViolationCount count : severityLevels) {
                    if (count.name == null) continue;
                    this.policySeverityCount.put(count.name, count);
                }
            }
        }
    }

    private void populatePolicyStatusMap() {
        List<ComponentVersionStatusCount> versionStatusCounts = this.policyStatusItem.componentVersionStatusCounts;
        if (versionStatusCounts != null) {
            for (ComponentVersionStatusCount policyStatus : versionStatusCounts) {
                if (policyStatus.name == null) continue;
                this.policyStatusCount.put(policyStatus.name, policyStatus);
            }
        }
    }

    public String getPolicyStatusMessage() {
        if (this.policyStatusItem.componentVersionStatusCounts == null || this.policyStatusItem.componentVersionStatusCounts.size() == 0) {
            return "The Hub found no components.";
        }
        int inViolationCount = this.getCountOfStatus(VersionBomPolicyStatusOverallStatusEnum.IN_VIOLATION);
        int inViolationOverriddenCount = this.getCountOfStatus(VersionBomPolicyStatusOverallStatusEnum.IN_VIOLATION_OVERRIDDEN);
        int notInViolationCount = this.getCountOfStatus(VersionBomPolicyStatusOverallStatusEnum.NOT_IN_VIOLATION);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The Hub found: ");
        stringBuilder.append(inViolationCount);
        stringBuilder.append(" components in violation");
        if (this.getCountOfStatus(VersionBomPolicyStatusOverallStatusEnum.IN_VIOLATION) != 0) {
            stringBuilder.append(" (");
            this.getPolicySeverityMessage(stringBuilder);
            stringBuilder.append(")");
        }
        stringBuilder.append(", ");
        stringBuilder.append(inViolationOverriddenCount);
        stringBuilder.append(" components in violation, but overridden, and ");
        stringBuilder.append(notInViolationCount);
        stringBuilder.append(" components not in violation.");
        return stringBuilder.toString();
    }

    private void getPolicySeverityMessage(StringBuilder stringBuilder) {
        ArrayList<String> policySeverityItems = new ArrayList<String>();
        stringBuilder.append("Policy Severity counts: ");
        for (PolicySeverityEnum policySeverityEnum : this.policySeverityCount.keySet()) {
            ComponentVersionPolicyViolationCount policySeverity = this.policySeverityCount.get((Object)policySeverityEnum);
            if (policySeverity == null) continue;
            policySeverityItems.add(policySeverity.value + " component(s) have a severity level of " + policySeverityEnum.toString());
        }
        stringBuilder.append(StringUtils.join(policySeverityItems, ", "));
    }

    public ComponentVersionStatusCount getCountInViolation() {
        return this.policyStatusCount.get((Object)VersionBomPolicyStatusOverallStatusEnum.IN_VIOLATION);
    }

    public ComponentVersionStatusCount getCountNotInViolation() {
        return this.policyStatusCount.get((Object)VersionBomPolicyStatusOverallStatusEnum.NOT_IN_VIOLATION);
    }

    public ComponentVersionStatusCount getCountInViolationOverridden() {
        return this.policyStatusCount.get((Object)VersionBomPolicyStatusOverallStatusEnum.IN_VIOLATION_OVERRIDDEN);
    }

    public int getCountOfStatus(VersionBomPolicyStatusOverallStatusEnum overallStatus) {
        ComponentVersionStatusCount count = this.policyStatusCount.get((Object)overallStatus);
        if (count == null) {
            return 0;
        }
        return count.value;
    }

    public int getCountOfSeverity(PolicySeverityEnum severity) {
        ComponentVersionPolicyViolationCount count = this.policySeverityCount.get((Object)severity);
        if (count == null) {
            return 0;
        }
        return count.value;
    }
}

