/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.extension.transformer;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.extension.ExtensionConfigService;
import com.blackducksoftware.integration.hub.api.user.UserService;
import com.blackducksoftware.integration.hub.dataservice.ItemTransform;
import com.blackducksoftware.integration.hub.dataservice.extension.item.UserConfigItem;
import com.blackducksoftware.integration.hub.model.view.ExternalExtensionConfigValueView;
import com.blackducksoftware.integration.hub.model.view.ExternalExtensionUserView;
import com.blackducksoftware.integration.hub.model.view.UserView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserConfigTransform
implements ItemTransform<List<UserConfigItem>, ExternalExtensionUserView> {
    private final UserService userRequestService;
    private final ExtensionConfigService extensionConfigRequestService;

    public UserConfigTransform(UserService userRequestService, ExtensionConfigService extensionConfigRequestService) {
        this.userRequestService = userRequestService;
        this.extensionConfigRequestService = extensionConfigRequestService;
    }

    @Override
    public List<UserConfigItem> transform(ExternalExtensionUserView item) throws IntegrationException {
        UserView user = this.userRequestService.getView(item.user, UserView.class);
        if (!user.active.booleanValue()) {
            return Collections.emptyList();
        }
        Map<String, ExternalExtensionConfigValueView> configItems = this.getUserConfigOptions(item.extensionOptions);
        ArrayList<UserConfigItem> itemList = new ArrayList<UserConfigItem>(configItems.size());
        itemList.add(new UserConfigItem(user, configItems));
        return itemList;
    }

    private Map<String, ExternalExtensionConfigValueView> getUserConfigOptions(String userConfigUrl) throws IntegrationException {
        List<ExternalExtensionConfigValueView> userItemList = this.extensionConfigRequestService.getUserConfiguration(userConfigUrl);
        Map<String, ExternalExtensionConfigValueView> itemMap = this.createConfigMap(userItemList);
        return itemMap;
    }

    private Map<String, ExternalExtensionConfigValueView> createConfigMap(List<ExternalExtensionConfigValueView> itemList) {
        HashMap<String, ExternalExtensionConfigValueView> itemMap = new HashMap<String, ExternalExtensionConfigValueView>(itemList.size());
        for (ExternalExtensionConfigValueView item : itemList) {
            itemMap.put(item.name, item);
        }
        return itemMap;
    }
}

