/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.scan;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.model.response.DryRunUploadResponse;
import com.blackducksoftware.integration.hub.request.HubRequest;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;

public class DryRunUploadService
extends HubService {
    private static final List<String> DRY_RUN_UPLOAD_SEGMENTS = Arrays.asList("api", "v1", "scans");

    public DryRunUploadService(RestConnection restConnection) {
        super(restConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DryRunUploadResponse uploadDryRunFile(File dryRunFile) throws IntegrationException {
        DryRunUploadResponse dryRunUploadResponse;
        HubRequest uploadDryRunFileRequest = this.getHubRequestFactory().createRequest(DRY_RUN_UPLOAD_SEGMENTS);
        Response response = null;
        try {
            response = uploadDryRunFileRequest.executePost("application/json", dryRunFile);
            String responseString = this.readResponseString(response);
            DryRunUploadResponse uploadResponse = this.getGson().fromJson(responseString, DryRunUploadResponse.class);
            uploadResponse.json = responseString;
            dryRunUploadResponse = uploadResponse;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(response);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)response);
        return dryRunUploadResponse;
    }
}

