import re
from blackduck.hub_services_helper import HubServicesHelper
from com.blackducksoftware.integration.hub.exception import DoesNotExistException
if not blackduckServer:
    raise Exception("Blackduck server ID must be provided")


def normalize_key(key):
    return re.search('(vulnerability|operational|license)(Risk(High|Low|Medium|None)Count)', key).group(3)

hub_services_helper = HubServicesHelper(params=blackduckServer)
hub_services_factory = hub_services_helper.get_hub_services_factory()
risk_report_data_service = hub_services_factory.createRiskReportDataService(20000)
try:

    risk_data = risk_report_data_service.getRiskReportData(projectName, version)
    riskTypeAttributes = {'Security Risks': ['vulnerabilityRiskHighCount', 'vulnerabilityRiskLowCount', 'vulnerabilityRiskMediumCount', 'vulnerabilityRiskNoneCount'],
                          'Operational Risks': ['operationalRiskHighCount', 'operationalRiskLowCount', 'operationalRiskMediumCount', 'operationalRiskNoneCount'],
                          'License Risks': ['licenseRiskHighCount', 'licenseRiskLowCount', 'licenseRiskMediumCount', 'licenseRiskNoneCount']}
    data = {'riskProfile': {normalize_key(key): risk_data.__getattribute__(key) for key in riskTypeAttributes[riskType]},
            'projectName': risk_data.projectName, 'projectVersion': risk_data.projectVersion,
            'projectVersionURL': risk_data.projectVersionURL, 'riskType': riskType}
except DoesNotExistException as exception:
    data = {'error': exception.message}

