/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.service;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.view.MetaHandler;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.model.HubView;
import com.blackducksoftware.integration.hub.model.enumeration.AllowEnum;
import com.blackducksoftware.integration.hub.model.view.components.LinkView;
import com.blackducksoftware.integration.hub.model.view.components.MetaView;
import com.blackducksoftware.integration.hub.request.HubPagedRequest;
import com.blackducksoftware.integration.hub.request.HubRequest;
import com.blackducksoftware.integration.hub.request.HubRequestFactory;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.AllHubViewsTransformer;
import com.blackducksoftware.integration.hub.service.HubViewTransformer;
import com.blackducksoftware.integration.hub.service.HubViewsTransformer;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import okhttp3.Response;

public class HubService {
    private final MetaHandler metaHandler;
    private final HubViewTransformer hubViewManager;
    private final HubViewsTransformer hubViewsTransformer;
    private final AllHubViewsTransformer allHubViewsTransformer;
    private final HubRequestFactory hubRequestFactory;
    private final URL hubBaseUrl;
    private final JsonParser jsonParser;
    private final Gson gson;

    public HubService(RestConnection restConnection) {
        this.hubRequestFactory = new HubRequestFactory(restConnection);
        this.hubBaseUrl = restConnection.hubBaseUrl;
        this.jsonParser = restConnection.jsonParser;
        this.gson = restConnection.gson;
        this.metaHandler = new MetaHandler(restConnection.logger);
        this.hubViewManager = new HubViewTransformer(this.hubRequestFactory, this.metaHandler, this.jsonParser, this.gson);
        this.hubViewsTransformer = new HubViewsTransformer(this.hubViewManager, this.jsonParser);
        this.allHubViewsTransformer = new AllHubViewsTransformer(this.hubViewsTransformer, this.hubRequestFactory, this.metaHandler, this.jsonParser);
    }

    public URL getHubBaseUrl() {
        return this.hubBaseUrl;
    }

    public HubRequestFactory getHubRequestFactory() {
        return this.hubRequestFactory;
    }

    public JsonParser getJsonParser() {
        return this.jsonParser;
    }

    public Gson getGson() {
        return this.gson;
    }

    public String readResponseString(Response response) throws IntegrationException {
        try {
            return response.body().string();
        }
        catch (IOException e) {
            throw new IntegrationException(e);
        }
    }

    public boolean hasLink(HubView view, String linkKey) throws HubIntegrationException {
        return this.metaHandler.hasLink(view, linkKey);
    }

    public String getFirstLink(HubView view, String linkKey) throws HubIntegrationException {
        return this.metaHandler.getFirstLink(view, linkKey);
    }

    public String getFirstLinkSafely(HubView view, String linkKey) {
        return this.metaHandler.getFirstLinkSafely(view, linkKey);
    }

    public List<String> getLinks(HubView view, String linkKey) throws HubIntegrationException {
        return this.metaHandler.getLinks(view, linkKey);
    }

    public MetaView getMetaView(HubView view) throws HubIntegrationException {
        return this.metaHandler.getMetaView(view);
    }

    public List<LinkView> getLinkViews(HubView view) throws HubIntegrationException {
        return this.metaHandler.getLinkViews(view);
    }

    public List<AllowEnum> getAllowedMethods(HubView view) throws HubIntegrationException {
        return this.metaHandler.getAllowedMethods(view);
    }

    public String getHref(HubView view) throws HubIntegrationException {
        return this.metaHandler.getHref(view);
    }

    public <T extends HubView> T getViewFromLinkSafely(HubView hubView, String metaLinkRef, Class<T> clazz) throws IntegrationException {
        return this.hubViewManager.getViewFromLinkSafely(hubView, metaLinkRef, clazz);
    }

    public <T extends HubView> T getViewFromLinkSafely(HubView hubView, String metaLinkRef, Class<T> clazz, String mediaType) throws IntegrationException {
        return this.hubViewManager.getViewFromLinkSafely(hubView, metaLinkRef, clazz, mediaType);
    }

    public <T extends HubView> T getViewFromLink(HubView hubView, String metaLinkRef, Class<T> clazz) throws IntegrationException {
        return this.hubViewManager.getViewFromLink(hubView, metaLinkRef, clazz);
    }

    public <T extends HubView> T getViewFromLink(HubView hubView, String metaLinkRef, Class<T> clazz, String mediaType) throws IntegrationException {
        return this.hubViewManager.getViewFromLink(hubView, metaLinkRef, clazz, mediaType);
    }

    public <T extends HubView> T getView(HubRequest request, Class<T> clazz) throws IntegrationException {
        return this.hubViewManager.getView(request, clazz);
    }

    public <T extends HubView> T getView(String url, Class<T> clazz) throws IntegrationException {
        return this.hubViewManager.getView(url, clazz);
    }

    public <T extends HubView> T getView(String url, Class<T> clazz, String mediaType) throws IntegrationException {
        return this.hubViewManager.getView(url, clazz, mediaType);
    }

    public <T extends HubView> T getView(HubRequest request, Class<T> clazz, String mediaType) throws IntegrationException {
        return this.hubViewManager.getView(request, clazz, mediaType);
    }

    public <T extends HubView> T getViewAs(JsonElement view, Class<T> clazz) {
        return this.hubViewManager.getViewAs(view, clazz);
    }

    public <T extends HubView> T getViewAs(String view, Class<T> clazz) {
        return this.hubViewManager.getViewAs(view, clazz);
    }

    public <T extends HubView> List<T> getViews(JsonArray viewsArray, Class<T> clazz) {
        return this.hubViewsTransformer.getViews(viewsArray, clazz);
    }

    public <T extends HubView> List<T> getViews(JsonObject jsonObject, Class<T> clazz) throws IntegrationException {
        return this.hubViewsTransformer.getViews(jsonObject, clazz);
    }

    public <T extends HubView> List<T> getViews(HubPagedRequest hubPagedRequest, Class<T> clazz) throws IntegrationException {
        return this.hubViewsTransformer.getViews(hubPagedRequest, clazz);
    }

    public <T extends HubView> List<T> getViews(HubPagedRequest hubPagedRequest, Class<T> clazz, String mediaType) throws IntegrationException {
        return this.hubViewsTransformer.getViews(hubPagedRequest, clazz, mediaType);
    }

    public <T extends HubView> List<T> getAllViewsFromApi(String apiSegment, Class<T> clazz) throws IntegrationException {
        return this.allHubViewsTransformer.getAllViewsFromApi(apiSegment, clazz);
    }

    public <T extends HubView> List<T> getAllViewsFromApi(String apiSegment, Class<T> clazz, String mediaType) throws IntegrationException {
        return this.allHubViewsTransformer.getAllViewsFromApi(apiSegment, clazz, mediaType);
    }

    public <T extends HubView> List<T> getAllViewsFromApi(String apiSegment, Class<T> clazz, int viewsPerPage) throws IntegrationException {
        return this.allHubViewsTransformer.getAllViewsFromApi(apiSegment, clazz, viewsPerPage);
    }

    public <T extends HubView> List<T> getAllViewsFromApi(String apiSegment, Class<T> clazz, int viewsPerPage, String mediaType) throws IntegrationException {
        return this.allHubViewsTransformer.getAllViewsFromApi(apiSegment, clazz, viewsPerPage, mediaType);
    }

    public <T extends HubView> List<T> getAllViewsFromLinkSafely(HubView hubView, String metaLinkRef, Class<T> clazz) throws IntegrationException {
        return this.allHubViewsTransformer.getAllViewsFromLinkSafely(hubView, metaLinkRef, clazz);
    }

    public <T extends HubView> List<T> getAllViewsFromLinkSafely(HubView hubView, String metaLinkRef, Class<T> clazz, String mediaType) throws IntegrationException {
        return this.allHubViewsTransformer.getAllViewsFromLinkSafely(hubView, metaLinkRef, clazz, mediaType);
    }

    public <T extends HubView> List<T> getAllViewsFromLink(HubView hubView, String metaLinkRef, Class<T> clazz) throws IntegrationException {
        return this.allHubViewsTransformer.getAllViewsFromLink(hubView, metaLinkRef, clazz);
    }

    public <T extends HubView> List<T> getAllViewsFromLink(HubView hubView, String metaLinkRef, Class<T> clazz, String mediaType) throws IntegrationException {
        return this.allHubViewsTransformer.getAllViewsFromLink(hubView, metaLinkRef, clazz, mediaType);
    }

    public <T extends HubView> List<T> getAllViews(HubPagedRequest hubPagedRequest, Class<T> clazz) throws IntegrationException {
        return this.allHubViewsTransformer.getAllViews(hubPagedRequest, clazz);
    }

    public <T extends HubView> List<T> getAllViews(String url, Class<T> clazz) throws IntegrationException {
        return this.allHubViewsTransformer.getAllViews(url, clazz);
    }

    public <T extends HubView> List<T> getAllViews(String url, Class<T> clazz, String mediaType) throws IntegrationException {
        return this.allHubViewsTransformer.getAllViews(url, clazz, mediaType);
    }

    public <T extends HubView> List<T> getAllViews(HubPagedRequest hubPagedRequest, Class<T> clazz, String mediaType) throws IntegrationException {
        return this.allHubViewsTransformer.getAllViews(hubPagedRequest, clazz, mediaType);
    }
}

