/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.notification.processor;

import com.blackducksoftware.integration.hub.dataservice.notification.model.NotificationContentItem;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.notification.processor.NotificationSubProcessor;
import com.blackducksoftware.integration.hub.notification.processor.SubProcessorCache;
import com.blackducksoftware.integration.hub.notification.processor.event.NotificationEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public abstract class NotificationProcessor<T> {
    private final Map<Class<?>, NotificationSubProcessor> processorMap = new HashMap();
    private final List<SubProcessorCache> cacheList = new ArrayList<SubProcessorCache>();

    public T process(SortedSet<NotificationContentItem> notifications) throws HubIntegrationException {
        this.createEvents(notifications);
        Collection<NotificationEvent> events = this.collectEvents();
        return this.processEvents(events);
    }

    private void createEvents(SortedSet<NotificationContentItem> notifications) throws HubIntegrationException {
        for (NotificationContentItem item : notifications) {
            Class<?> key = item.getClass();
            if (!this.processorMap.containsKey(key)) continue;
            NotificationSubProcessor processor = this.processorMap.get(key);
            processor.process(item);
        }
    }

    public abstract T processEvents(Collection<NotificationEvent> var1) throws HubIntegrationException;

    private Collection<NotificationEvent> collectEvents() throws HubIntegrationException {
        LinkedList<NotificationEvent> eventList = new LinkedList<NotificationEvent>();
        for (SubProcessorCache processor : this.cacheList) {
            eventList.addAll(processor.getEvents());
        }
        return eventList;
    }

    public Map<Class<?>, NotificationSubProcessor> getProcessorMap() {
        return this.processorMap;
    }

    public List<SubProcessorCache> getCacheList() {
        return this.cacheList;
    }
}

