/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.cli;

import com.blackducksoftware.integration.exception.EncryptionException;
import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.HubSupportHelper;
import com.blackducksoftware.integration.hub.ScannerSplitStream;
import com.blackducksoftware.integration.hub.StreamRedirectThread;
import com.blackducksoftware.integration.hub.capability.HubCapabilitiesEnum;
import com.blackducksoftware.integration.hub.certificate.HubCertificateHandler;
import com.blackducksoftware.integration.hub.cli.CLILocation;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.exception.ScanFailedException;
import com.blackducksoftware.integration.hub.global.HubServerConfig;
import com.blackducksoftware.integration.hub.model.view.ScanSummaryView;
import com.blackducksoftware.integration.hub.proxy.ProxyInfo;
import com.blackducksoftware.integration.hub.scan.HubScanConfig;
import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.util.CIEnvironmentVariables;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SimpleScanUtility {
    public static final int DEFAULT_MEMORY = 4096;
    private final Gson gson;
    private final IntLogger logger;
    private final HubServerConfig hubServerConfig;
    private final HubSupportHelper hubSupportHelper;
    private final CIEnvironmentVariables ciEnvironmentVariables;
    private final HubScanConfig hubScanConfig;
    private final String project;
    private final String version;
    private final List<String> cmd = new ArrayList<String>();
    private File logDirectory;

    public SimpleScanUtility(IntLogger logger, Gson gson, HubServerConfig hubServerConfig, HubSupportHelper hubSupportHelper, CIEnvironmentVariables ciEnvironmentVariables, HubScanConfig hubScanConfig, String project, String version) {
        this.gson = gson;
        this.logger = logger;
        this.hubServerConfig = hubServerConfig;
        this.hubSupportHelper = hubSupportHelper;
        this.ciEnvironmentVariables = ciEnvironmentVariables;
        this.hubScanConfig = hubScanConfig;
        this.project = project;
        this.version = version;
    }

    public void setupAndExecuteScan() throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        CLILocation cliLocation = new CLILocation(this.logger, this.hubScanConfig.getToolsDir());
        this.setupAndExecuteScan(cliLocation);
    }

    public void setupAndExecuteScan(CLILocation cliLocation) throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        String logDirectoryPath;
        String pathToScanExecutable;
        String pathToOneJar;
        String pathToJavaExecutable;
        try {
            pathToJavaExecutable = cliLocation.getProvidedJavaExec().getCanonicalPath();
            pathToOneJar = cliLocation.getOneJarFile().getCanonicalPath();
            pathToScanExecutable = cliLocation.getCLI(this.logger).getCanonicalPath();
        }
        catch (IOException e) {
            throw new HubIntegrationException(String.format("The provided directory %s did not have a Hub CLI.", this.hubScanConfig.getToolsDir().getAbsolutePath()), e);
        }
        this.logger.debug("Using this java installation : " + pathToJavaExecutable);
        if (this.hubServerConfig.isAlwaysTrustServerCertificate() && !this.hubScanConfig.isDryRun()) {
            try {
                HubCertificateHandler hubCertificateHandler = new HubCertificateHandler(this.logger, cliLocation.getJavaHome());
                hubCertificateHandler.importHttpsCertificateForHubServer(this.hubServerConfig);
            }
            catch (IntegrationException | IOException e) {
                this.logger.error("Could not automatically import the certificate to the CLI: " + e.getMessage());
            }
        }
        this.cmd.add(pathToJavaExecutable);
        this.cmd.add("-Done-jar.silent=true");
        this.cmd.add("-Done-jar.jar.path=" + pathToOneJar);
        if (this.hubServerConfig.shouldUseProxyForHub() && !this.hubScanConfig.isDryRun()) {
            ProxyInfo hubProxyInfo = this.hubServerConfig.getProxyInfo();
            String proxyHost = hubProxyInfo.getHost();
            int proxyPort = hubProxyInfo.getPort();
            String proxyUsername = hubProxyInfo.getUsername();
            String proxyPassword = hubProxyInfo.getDecryptedPassword();
            this.cmd.add("-Dhttp.proxyHost=" + proxyHost);
            this.cmd.add("-Dhttp.proxyPort=" + Integer.toString(proxyPort));
            if (StringUtils.isNotBlank(proxyUsername) && StringUtils.isNotBlank(proxyPassword)) {
                this.cmd.add("-Dhttp.proxyUser=" + proxyUsername);
                this.cmd.add("-Dhttp.proxyPassword=" + proxyPassword);
            } else {
                this.cmd.add("-Dhttp.proxyUser=user");
                this.cmd.add("-Dhttp.proxyPassword=password");
            }
        }
        this.cmd.add("-Xmx" + this.hubScanConfig.getScanMemory() + "m");
        this.cmd.add("-jar");
        this.cmd.add(pathToScanExecutable);
        if (this.hubSupportHelper.hasCapability(HubCapabilitiesEnum.CLI_INSECURE_OPTION)) {
            this.cmd.add("--no-prompt");
        }
        if (!this.hubScanConfig.isDryRun()) {
            int hubPort;
            this.cmd.add("--scheme");
            this.cmd.add(this.hubServerConfig.getHubUrl().getProtocol());
            this.cmd.add("--host");
            this.cmd.add(this.hubServerConfig.getHubUrl().getHost());
            this.logger.debug("Using this Hub hostname : '" + this.hubServerConfig.getHubUrl().getHost() + "'");
            this.cmd.add("--username");
            this.cmd.add(this.hubServerConfig.getGlobalCredentials().getUsername());
            if (!this.hubSupportHelper.hasCapability(HubCapabilitiesEnum.CLI_PASSWORD_ENVIRONMENT_VARIABLE)) {
                this.cmd.add("--password");
                this.cmd.add(this.hubServerConfig.getGlobalCredentials().getDecryptedPassword());
            }
            if ((hubPort = this.hubServerConfig.getHubUrl().getPort()) > 0) {
                this.cmd.add("--port");
                this.cmd.add(Integer.toString(hubPort));
            } else {
                int defaultPort = this.hubServerConfig.getHubUrl().getDefaultPort();
                if (defaultPort > 0) {
                    this.cmd.add("--port");
                    this.cmd.add(Integer.toString(defaultPort));
                } else {
                    this.logger.warn("Could not find a port to use for the Server.");
                }
            }
        }
        this.makeVerbose(this.cmd);
        try {
            this.populateLogDirectory();
            logDirectoryPath = this.logDirectory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new HubIntegrationException("Exception creating the log directory for the cli scan: " + e.getMessage(), e);
        }
        this.cmd.add("--logDir");
        this.cmd.add(logDirectoryPath);
        if (this.hubScanConfig.isDryRun()) {
            this.cmd.add("--dryRunWriteDir");
            this.cmd.add(logDirectoryPath);
        }
        if (this.hubSupportHelper.hasCapability(HubCapabilitiesEnum.CLI_STATUS_DIRECTORY_OPTION)) {
            this.cmd.add("--statusWriteDir");
            this.cmd.add(logDirectoryPath);
        }
        if (StringUtils.isNotBlank(this.project) && StringUtils.isNotBlank(this.version)) {
            this.cmd.add("--project");
            this.cmd.add(this.project);
            this.cmd.add("--release");
            this.cmd.add(this.version);
        }
        if (this.hubSupportHelper.hasCapability(HubCapabilitiesEnum.CODE_LOCATION_ALIAS) && StringUtils.isNotBlank(this.hubScanConfig.getCodeLocationAlias())) {
            this.cmd.add("--name");
            this.cmd.add(this.hubScanConfig.getCodeLocationAlias());
        }
        if (this.hubSupportHelper.hasCapability(HubCapabilitiesEnum.CLI_SNIPPET_MODE) && this.hubScanConfig.isSnippetModeEnabled()) {
            this.cmd.add("--snippet-matching");
        }
        if (this.hubScanConfig.getExcludePatterns() != null) {
            for (String exclusionPattern : this.hubScanConfig.getExcludePatterns()) {
                if (!StringUtils.isNotBlank(exclusionPattern)) continue;
                this.cmd.add("--exclude");
                this.cmd.add(exclusionPattern);
            }
        }
        for (String target : this.hubScanConfig.getScanTargetPaths()) {
            this.cmd.add(target);
        }
        try {
            this.executeScan();
        }
        catch (IOException e) {
            throw new HubIntegrationException("Exception executing the cli scan: " + e.getMessage(), e);
        }
    }

    private void executeScan() throws IllegalArgumentException, EncryptionException, IOException, HubIntegrationException {
        this.printCommand();
        File standardOutFile = this.getStandardOutputFile();
        standardOutFile.createNewFile();
        try (FileOutputStream outputFileStream = new FileOutputStream(standardOutFile);){
            ScannerSplitStream splitOutputStream = new ScannerSplitStream(this.logger, outputFileStream);
            ProcessBuilder processBuilder = new ProcessBuilder(this.cmd).redirectError(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE);
            if (!this.hubScanConfig.isDryRun()) {
                processBuilder.environment().put("BD_HUB_PASSWORD", this.hubServerConfig.getGlobalCredentials().getDecryptedPassword());
            }
            processBuilder.environment().put("BD_HUB_NO_PROMPT", "true");
            String bdioEnvVar = this.ciEnvironmentVariables.getValue("BD_HUB_DECLARED_COMPONENTS");
            if (StringUtils.isNotBlank(bdioEnvVar)) {
                processBuilder.environment().put("BD_HUB_DECLARED_COMPONENTS", bdioEnvVar);
            }
            Process hubCliProcess = processBuilder.start();
            StreamRedirectThread redirectThread = new StreamRedirectThread(hubCliProcess.getErrorStream(), splitOutputStream);
            redirectThread.start();
            int returnCode = -1;
            try {
                returnCode = hubCliProcess.waitFor();
                redirectThread.join();
            }
            catch (InterruptedException e) {
                throw new HubIntegrationException("The thread waiting for the cli to complete was interrupted: " + e.getMessage(), e);
            }
            splitOutputStream.flush();
            this.logger.info(IOUtils.toString((InputStream)hubCliProcess.getInputStream(), (Charset)StandardCharsets.UTF_8));
            this.logger.info("Hub CLI return code : " + returnCode);
            this.logger.info("You can view the BlackDuck Scan CLI logs at : '" + this.logDirectory.getCanonicalPath() + "'");
            if (returnCode != 0) {
                throw new ScanFailedException("The scan failed with return code : " + returnCode);
            }
        }
    }

    public List<ScanSummaryView> getScanSummaryItems() {
        if (this.logDirectory == null || !this.logDirectory.exists()) {
            return Collections.emptyList();
        }
        File scanStatusDirectory = this.getStatusDirectory();
        if (!scanStatusDirectory.exists()) {
            return Collections.emptyList();
        }
        File[] statusFiles = scanStatusDirectory.listFiles();
        if (statusFiles.length != this.hubScanConfig.getScanTargetPaths().size()) {
            this.logger.error(String.format("There were %d scans target paths and %d status files.", this.hubScanConfig.getScanTargetPaths().size(), statusFiles.length));
            return Collections.emptyList();
        }
        ArrayList<ScanSummaryView> scanSummaryItems = new ArrayList<ScanSummaryView>();
        for (File currentStatusFile : statusFiles) {
            String fileContent;
            try {
                fileContent = FileUtils.readFileToString((File)currentStatusFile, (String)"UTF8");
            }
            catch (IOException e) {
                this.logger.error(String.format("There was an exception reading the status file: %s", e.getMessage(), e));
                return Collections.emptyList();
            }
            ScanSummaryView scanSummaryItem = this.gson.fromJson(fileContent, ScanSummaryView.class);
            scanSummaryItem.json = fileContent;
            scanSummaryItems.add(scanSummaryItem);
        }
        return scanSummaryItems;
    }

    public String getSpecificScanExecutionLogDirectory() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd_HH-mm-ss-SSS").withZoneUTC();
        String timeString = DateTime.now().withZone(DateTimeZone.UTC).toString(dateTimeFormatter);
        return timeString;
    }

    private void populateLogDirectory() throws IOException {
        String logDirectoryName = "HubScanLogs";
        File logsDirectory = new File(this.hubScanConfig.getWorkingDirectory(), "HubScanLogs");
        String specificScanExecutionLogDirectory = this.getSpecificScanExecutionLogDirectory();
        this.logDirectory = new File(logsDirectory, specificScanExecutionLogDirectory);
        if (!this.logDirectory.exists() && !this.logDirectory.mkdirs()) {
            throw new IOException(String.format("Could not create the %s directory!", this.logDirectory.getAbsolutePath()));
        }
        File bdIgnoreLogsFile = new File(this.hubScanConfig.getWorkingDirectory(), ".bdignore");
        if (bdIgnoreLogsFile.exists()) {
            bdIgnoreLogsFile.delete();
        }
        if (!bdIgnoreLogsFile.createNewFile()) {
            throw new IOException(String.format("Could not create the %s file!", bdIgnoreLogsFile.getAbsolutePath()));
        }
        String exclusionPattern = "/HubScanLogs/";
        Files.write(bdIgnoreLogsFile.toPath(), "/HubScanLogs/".getBytes(), new OpenOption[0]);
    }

    private void printCommand() {
        ArrayList<String> cmdToOutput = new ArrayList<String>();
        cmdToOutput.addAll(this.cmd);
        int passwordIndex = cmdToOutput.indexOf("--password");
        if (passwordIndex > -1) {
            ++passwordIndex;
        }
        int proxyPasswordIndex = -1;
        for (int commandIndex = 0; commandIndex < cmdToOutput.size(); ++commandIndex) {
            String commandParameter = (String)cmdToOutput.get(commandIndex);
            if (!commandParameter.contains("-Dhttp.proxyPassword=")) continue;
            proxyPasswordIndex = commandIndex;
        }
        this.maskIndex(cmdToOutput, passwordIndex);
        this.maskIndex(cmdToOutput, proxyPasswordIndex);
        this.logger.info("Hub CLI command :");
        for (String current : cmdToOutput) {
            this.logger.info(current);
        }
    }

    private void maskIndex(List<String> cmd, int indexToMask) {
        if (indexToMask > -1) {
            String cmdToMask = cmd.get(indexToMask);
            Object[] maskedArray = new String[cmdToMask.length()];
            Arrays.fill(maskedArray, "*");
            cmd.set(indexToMask, StringUtils.join(maskedArray));
        }
    }

    private void makeVerbose(List<String> cmd) {
        if (this.hubScanConfig.isVerbose()) {
            cmd.add("-v");
        }
        if (this.hubScanConfig.isDebug()) {
            cmd.add("--debug");
        }
    }

    public IntLogger getLogger() {
        return this.logger;
    }

    public List<String> getCmd() {
        return this.cmd;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public File getStatusDirectory() {
        return new File(this.logDirectory, "status");
    }

    public File getDataDirectory() {
        return new File(this.logDirectory, "data");
    }

    public File getCLILogDirectory() {
        return new File(this.logDirectory, "log");
    }

    public File getStandardOutputFile() {
        return new File(this.logDirectory, "CLI_Output.txt");
    }

    public File[] getScanSummaryFiles() {
        File scanStatusDirectory = this.getStatusDirectory();
        return scanStatusDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return FilenameUtils.wildcardMatchOnSystem((String)name, (String)"*.json");
            }
        });
    }

    public File[] getDryRunFiles() {
        File dataDirectory = this.getDataDirectory();
        return dataDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return FilenameUtils.wildcardMatchOnSystem((String)name, (String)"*.json");
            }
        });
    }
}

