/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.builder;

import com.blackducksoftware.integration.builder.AbstractBuilder;
import com.blackducksoftware.integration.hub.scan.HubScanConfig;
import com.blackducksoftware.integration.hub.validator.HubScanConfigValidator;
import com.blackducksoftware.integration.validator.AbstractValidator;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;

public class HubScanConfigBuilder
extends AbstractBuilder<HubScanConfig> {
    private File workingDirectory;
    private String scanMemory;
    private final Set<String> scanTargetPaths = new HashSet<String>();
    private boolean dryRun;
    private File toolsDir;
    private boolean disableScanTargetPathExistenceCheck;
    private boolean enableScanTargetPathsWithinWorkingDirectoryCheck;
    private boolean cleanupLogsOnSuccess = true;
    private String[] excludePatterns;
    private String codeLocationAlias;
    private boolean unmapPreviousCodeLocations;
    private boolean deletePreviousCodeLocations;
    private boolean debug;
    private boolean verbose = true;
    private boolean snippetModeEnabled;

    @Override
    public HubScanConfig buildObject() {
        HubScanConfig config = new HubScanConfig(this.workingDirectory, NumberUtils.toInt(this.scanMemory), Collections.unmodifiableSet(this.scanTargetPaths), this.dryRun, this.toolsDir, this.cleanupLogsOnSuccess, this.excludePatterns, this.codeLocationAlias, this.unmapPreviousCodeLocations, this.deletePreviousCodeLocations, this.debug, this.verbose, this.snippetModeEnabled);
        return config;
    }

    @Override
    public AbstractValidator createValidator() {
        HubScanConfigValidator validator = new HubScanConfigValidator();
        validator.setScanMemory(this.scanMemory);
        validator.setWorkingDirectory(this.workingDirectory);
        validator.addAllScanTargetPaths(this.scanTargetPaths);
        if (this.disableScanTargetPathExistenceCheck) {
            validator.disableScanTargetPathExistenceCheck();
        }
        if (this.enableScanTargetPathsWithinWorkingDirectoryCheck) {
            validator.enableScanTargetPathsWithinWorkingDirectoryCheck();
        }
        validator.setExcludePatterns(this.excludePatterns);
        return validator;
    }

    public void setCodeLocationAlias(String codeLocationAlias) {
        this.codeLocationAlias = codeLocationAlias;
    }

    public void setToolsDir(File toolsDir) {
        this.toolsDir = toolsDir;
    }

    public void setDisableScanTargetPathExistenceCheck(boolean disableScanTargetPathExistenceCheck) {
        this.disableScanTargetPathExistenceCheck = disableScanTargetPathExistenceCheck;
    }

    public void setEnableScanTargetPathsWithinWorkingDirectoryCheck(boolean enableScanTargetPathsWithinWorkingDirectoryCheck) {
        this.enableScanTargetPathsWithinWorkingDirectoryCheck = enableScanTargetPathsWithinWorkingDirectoryCheck;
    }

    public void setScanMemory(int scanMemory) {
        this.setScanMemory(String.valueOf(scanMemory));
    }

    public void setScanMemory(String scanMemory) {
        this.scanMemory = scanMemory;
    }

    public void addScanTargetPath(String scanTargetPath) {
        this.scanTargetPaths.add(scanTargetPath);
    }

    public void addAllScanTargetPaths(List<String> scanTargetPaths) {
        this.scanTargetPaths.addAll(scanTargetPaths);
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void disableScanTargetPathExistenceCheck() {
        this.disableScanTargetPathExistenceCheck = true;
    }

    public void enableScanTargetPathsWithinWorkingDirectoryCheck() {
        this.enableScanTargetPathsWithinWorkingDirectoryCheck = true;
    }

    public boolean isCleanupLogsOnSuccess() {
        return this.cleanupLogsOnSuccess;
    }

    public void setCleanupLogsOnSuccess(boolean cleanupLogsOnSuccess) {
        this.cleanupLogsOnSuccess = cleanupLogsOnSuccess;
    }

    public void setExcludePatterns(String[] excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public void setUnmapPreviousCodeLocations(boolean unmapPreviousCodeLocations) {
        this.unmapPreviousCodeLocations = unmapPreviousCodeLocations;
    }

    public void setDeletePreviousCodeLocations(boolean deletePreviousCodeLocations) {
        this.deletePreviousCodeLocations = deletePreviousCodeLocations;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setSnippetModeEnabled(boolean snippetModeEnabled) {
        this.snippetModeEnabled = snippetModeEnabled;
    }
}

