/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation.signaturescanner.command;

import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.SnippetMatching;
import java.util.List;
import java.util.function.Consumer;

public class BlackDuckOnlineProperties {
    public static final String ONLINE_CAPABILITY_NEEDED_WARNING = "No snippet functionality, license search, or uploading of source is supported when running a dry run signature scan.";
    private final SnippetMatching snippetMatchingMode;
    private final boolean uploadSource;
    private final boolean licenseSearch;
    private final boolean copyrightSearch;
    private final boolean snippetMatchingFlag;
    private final boolean snippetMatchingOnlyFlag;
    private final boolean fullSnippetScanFlag;

    public BlackDuckOnlineProperties(SnippetMatching snippetMatchingMode, boolean uploadSource, boolean licenseSearch, boolean copyrightSearch) {
        this.snippetMatchingMode = snippetMatchingMode;
        this.uploadSource = uploadSource;
        this.licenseSearch = licenseSearch;
        this.copyrightSearch = copyrightSearch;
        this.snippetMatchingFlag = SnippetMatching.SNIPPET_MATCHING == snippetMatchingMode || SnippetMatching.FULL_SNIPPET_MATCHING == snippetMatchingMode;
        this.snippetMatchingOnlyFlag = SnippetMatching.SNIPPET_MATCHING_ONLY == snippetMatchingMode || SnippetMatching.FULL_SNIPPET_MATCHING_ONLY == snippetMatchingMode;
        this.fullSnippetScanFlag = SnippetMatching.FULL_SNIPPET_MATCHING == snippetMatchingMode || SnippetMatching.FULL_SNIPPET_MATCHING_ONLY == snippetMatchingMode;
    }

    public boolean isOnlineCapabilityNeeded() {
        return this.snippetMatchingFlag || this.snippetMatchingOnlyFlag || this.uploadSource || this.licenseSearch;
    }

    public void addOnlineCommands(List<String> cmd) {
        if (this.snippetMatchingFlag || this.snippetMatchingOnlyFlag) {
            if (this.snippetMatchingFlag) {
                cmd.add("--snippet-matching");
            } else {
                cmd.add("--snippet-matching-only");
            }
            if (this.fullSnippetScanFlag) {
                cmd.add("--full-snippet-scan");
            }
        }
        if (this.licenseSearch) {
            cmd.add("--license-search");
        }
        if (this.copyrightSearch) {
            cmd.add("--copyright-search");
        }
        if (this.uploadSource) {
            cmd.add("--upload-source");
        }
    }

    public void warnIfOnlineIsNeeded(Consumer<String> stringConsumer) {
        if (this.isOnlineCapabilityNeeded()) {
            stringConsumer.accept(ONLINE_CAPABILITY_NEEDED_WARNING);
        }
    }

    public SnippetMatching getSnippetMatchingMode() {
        return this.snippetMatchingMode;
    }

    public boolean isSnippetMatching() {
        return this.snippetMatchingFlag;
    }

    public boolean isSnippetMatchingOnly() {
        return this.snippetMatchingOnlyFlag;
    }

    public boolean isFullSnippetScan() {
        return this.fullSnippetScanFlag;
    }

    public boolean isUploadSource() {
        return this.uploadSource;
    }

    public boolean isLicenseSearch() {
        return this.licenseSearch;
    }

    public boolean isCopyrightSearch() {
        return this.copyrightSearch;
    }
}

