/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.util;

import com.synopsys.integration.util.ExcludedIncludedFilter;
import com.synopsys.integration.util.TokenizerUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;

public class ExcludedIncludedWildcardFilter
extends ExcludedIncludedFilter {
    public static final ExcludedIncludedWildcardFilter EMPTY = new ExcludedIncludedWildcardFilter(Collections.emptyList(), Collections.emptyList());

    public static ExcludedIncludedWildcardFilter fromCommaSeparatedStrings(String toExclude, String toInclude) {
        return new ExcludedIncludedWildcardFilter(TokenizerUtils.createSetFromString(toExclude), TokenizerUtils.createSetFromString(toInclude));
    }

    public static ExcludedIncludedWildcardFilter fromCollections(Collection<String> toExclude, Collection<String> toInclude) {
        return new ExcludedIncludedWildcardFilter(toExclude, toInclude);
    }

    protected ExcludedIncludedWildcardFilter(Collection<String> toExcludeList, Collection<String> toIncludeList) {
        super(toExcludeList, toIncludeList);
    }

    @Override
    public boolean willExclude(String itemName) {
        return this.setContains(itemName, this.excludedSet, x$0 -> super.willExclude((String)x$0));
    }

    @Override
    public boolean willInclude(String itemName) {
        return this.setContains(itemName, this.includedSet, x$0 -> super.willInclude((String)x$0));
    }

    private boolean setContains(String itemName, Set<String> tokenSet, Predicate<String> superMethod) {
        for (String token : tokenSet) {
            if (!FilenameUtils.wildcardMatch((String)itemName, (String)token)) continue;
            return true;
        }
        return superMethod.test(itemName);
    }
}

