/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.api.generated.enumeration.ProjectCloneCategoriesType;
import com.synopsys.integration.blackduck.api.generated.enumeration.ProjectVersionDistributionType;
import com.synopsys.integration.blackduck.api.generated.view.ProjectVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.api.manual.temporary.component.ProjectRequest;
import com.synopsys.integration.blackduck.api.manual.temporary.component.ProjectVersionRequest;
import com.synopsys.integration.blackduck.api.manual.temporary.enumeration.ProjectVersionPhaseType;
import com.synopsys.integration.util.NameVersion;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ProjectSyncModel {
    private static final Set<String> IGNORED_REQUEST_FIELDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("versionRequest", "license")));
    private static final Set<Field> ALL_FIELDS = new HashSet<Field>();
    public static final Field CLONE_CATEGORIES_FIELD = ProjectSyncModel.getFieldSafely("cloneCategories");
    public static final Field CUSTOM_SIGNATURE_ENABLED_FIELD = ProjectSyncModel.getFieldSafely("customSignatureEnabled");
    public static final Field DESCRIPTION_FIELD = ProjectSyncModel.getFieldSafely("description");
    public static final Field NAME_FIELD = ProjectSyncModel.getFieldSafely("name");
    public static final Field PROJECT_LEVEL_ADJUSTMENTS_FIELD = ProjectSyncModel.getFieldSafely("projectLevelAdjustments");
    public static final Field PROJECT_OWNER_FIELD = ProjectSyncModel.getFieldSafely("projectOwner");
    public static final Field PROJECT_TIER_FIELD = ProjectSyncModel.getFieldSafely("projectTier");
    public static final Field CLONE_FROM_RELEASE_URL_FIELD = ProjectSyncModel.getFieldSafely("cloneFromReleaseUrl");
    public static final Field DISTRIBUTION_FIELD = ProjectSyncModel.getFieldSafely("distribution");
    public static final Field NICKNAME_FIELD = ProjectSyncModel.getFieldSafely("nickname");
    public static final Field PHASE_FIELD = ProjectSyncModel.getFieldSafely("phase");
    public static final Field RELEASE_COMMENTS_FIELD = ProjectSyncModel.getFieldSafely("releaseComments");
    public static final Field RELEASED_ON_FIELD = ProjectSyncModel.getFieldSafely("releasedOn");
    public static final Field VERSION_NAME_FIELD = ProjectSyncModel.getFieldSafely("versionName");
    private List<ProjectCloneCategoriesType> cloneCategories;
    private Boolean customSignatureEnabled;
    private String description;
    private String name;
    private Boolean projectLevelAdjustments;
    private String projectOwner;
    private Integer projectTier;
    private String cloneFromReleaseUrl;
    private ProjectVersionDistributionType distribution;
    private String nickname;
    private ProjectVersionPhaseType phase;
    private String releaseComments;
    private Date releasedOn;
    private String versionName;
    private final Set<Field> fieldsWithSetValues = new HashSet<Field>();

    private static Field getFieldSafely(String fieldName) {
        try {
            Field field = ProjectSyncModel.class.getDeclaredField(fieldName);
            ALL_FIELDS.add(field);
            return field;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ProjectSyncModel createWithDefaults(String projectName, String projectVersionName) {
        return ProjectSyncModel.createWithDefaults(new NameVersion(projectName, projectVersionName));
    }

    public static ProjectSyncModel createWithDefaults(NameVersion projectAndVersion) {
        ProjectSyncModel projectSyncModel = new ProjectSyncModel(projectAndVersion);
        projectSyncModel.setDistribution(ProjectVersionDistributionType.EXTERNAL);
        projectSyncModel.setPhase(ProjectVersionPhaseType.DEVELOPMENT);
        return projectSyncModel;
    }

    public ProjectSyncModel() {
    }

    public ProjectSyncModel(String projectName, String projectVersionName) {
        this(new NameVersion(projectName, projectVersionName));
    }

    public ProjectSyncModel(NameVersion projectAndVersion) {
        this.setName(projectAndVersion.getName());
        this.setVersionName(projectAndVersion.getVersion());
    }

    public ProjectRequest createProjectRequest() {
        ProjectRequest projectRequest = new ProjectRequest();
        projectRequest.setName(this.name);
        projectRequest.setDescription(this.description);
        projectRequest.setProjectLevelAdjustments(this.projectLevelAdjustments);
        projectRequest.setProjectOwner(this.projectOwner);
        projectRequest.setProjectTier(this.projectTier);
        projectRequest.setCloneCategories(this.cloneCategories);
        projectRequest.setCustomSignatureEnabled(this.customSignatureEnabled);
        projectRequest.setVersionRequest(this.createProjectVersionRequest());
        return projectRequest;
    }

    public ProjectVersionRequest createProjectVersionRequest() {
        ProjectVersionRequest projectVersionRequest = new ProjectVersionRequest();
        projectVersionRequest.setDistribution(this.distribution);
        projectVersionRequest.setPhase(this.phase);
        projectVersionRequest.setVersionName(this.versionName);
        projectVersionRequest.setReleaseComments(this.releaseComments);
        projectVersionRequest.setCloneFromReleaseUrl(this.cloneFromReleaseUrl);
        projectVersionRequest.setReleasedOn(this.releasedOn);
        projectVersionRequest.setNickname(this.nickname);
        return projectVersionRequest;
    }

    public void populateProjectView(ProjectView projectView) {
        if (this.fieldSet(CLONE_CATEGORIES_FIELD)) {
            projectView.setCloneCategories(this.cloneCategories);
        }
        if (this.fieldSet(CUSTOM_SIGNATURE_ENABLED_FIELD)) {
            projectView.setCustomSignatureEnabled(this.customSignatureEnabled);
        }
        if (this.fieldSet(DESCRIPTION_FIELD)) {
            projectView.setDescription(this.description);
        }
        if (this.fieldSet(NAME_FIELD)) {
            projectView.setName(this.name);
        }
        if (this.fieldSet(PROJECT_LEVEL_ADJUSTMENTS_FIELD)) {
            projectView.setProjectLevelAdjustments(this.projectLevelAdjustments);
        }
        if (this.fieldSet(PROJECT_OWNER_FIELD)) {
            projectView.setProjectOwner(this.projectOwner);
        }
        if (this.fieldSet(PROJECT_TIER_FIELD)) {
            projectView.setProjectTier(this.projectTier);
        }
    }

    public void populateProjectVersionView(ProjectVersionView projectVersionView) {
        if (this.fieldSet(DISTRIBUTION_FIELD)) {
            projectVersionView.setDistribution(this.distribution);
        }
        if (this.fieldSet(NICKNAME_FIELD)) {
            projectVersionView.setNickname(this.nickname);
        }
        if (this.fieldSet(PHASE_FIELD)) {
            projectVersionView.setPhase(this.phase);
        }
        if (this.fieldSet(RELEASE_COMMENTS_FIELD)) {
            projectVersionView.setReleaseComments(this.releaseComments);
        }
        if (this.fieldSet(RELEASED_ON_FIELD)) {
            projectVersionView.setReleasedOn(this.releasedOn);
        }
        if (this.fieldSet(VERSION_NAME_FIELD)) {
            projectVersionView.setVersionName(this.versionName);
        }
    }

    public boolean shouldHandleProjectVersion() {
        return this.fieldsWithSetValues.contains(VERSION_NAME_FIELD) && StringUtils.isNotBlank((CharSequence)this.versionName);
    }

    public List<ProjectCloneCategoriesType> getCloneCategories() {
        return this.cloneCategories;
    }

    public void setCloneCategories(List<ProjectCloneCategoriesType> cloneCategories) {
        this.cloneCategories = cloneCategories;
        this.fieldsWithSetValues.add(CLONE_CATEGORIES_FIELD);
    }

    public Boolean getCustomSignatureEnabled() {
        return this.customSignatureEnabled;
    }

    public void setCustomSignatureEnabled(Boolean customSignatureEnabled) {
        this.customSignatureEnabled = customSignatureEnabled;
        this.fieldsWithSetValues.add(CUSTOM_SIGNATURE_ENABLED_FIELD);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fieldsWithSetValues.add(DESCRIPTION_FIELD);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fieldsWithSetValues.add(NAME_FIELD);
    }

    public Boolean getProjectLevelAdjustments() {
        return this.projectLevelAdjustments;
    }

    public void setProjectLevelAdjustments(Boolean projectLevelAdjustments) {
        this.projectLevelAdjustments = projectLevelAdjustments;
        this.fieldsWithSetValues.add(PROJECT_LEVEL_ADJUSTMENTS_FIELD);
    }

    public String getProjectOwner() {
        return this.projectOwner;
    }

    public void setProjectOwner(String projectOwner) {
        this.projectOwner = projectOwner;
        this.fieldsWithSetValues.add(PROJECT_OWNER_FIELD);
    }

    public Integer getProjectTier() {
        return this.projectTier;
    }

    public void setProjectTier(Integer projectTier) {
        this.projectTier = projectTier;
        this.fieldsWithSetValues.add(PROJECT_TIER_FIELD);
    }

    public String getCloneFromReleaseUrl() {
        return this.cloneFromReleaseUrl;
    }

    public void setCloneFromReleaseUrl(String cloneFromReleaseUrl) {
        this.cloneFromReleaseUrl = cloneFromReleaseUrl;
        this.fieldsWithSetValues.add(CLONE_FROM_RELEASE_URL_FIELD);
    }

    public ProjectVersionDistributionType getDistribution() {
        return this.distribution;
    }

    public void setDistribution(ProjectVersionDistributionType distribution) {
        this.distribution = distribution;
        this.fieldsWithSetValues.add(DISTRIBUTION_FIELD);
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
        this.fieldsWithSetValues.add(NICKNAME_FIELD);
    }

    public ProjectVersionPhaseType getPhase() {
        return this.phase;
    }

    public void setPhase(ProjectVersionPhaseType phase) {
        this.phase = phase;
        this.fieldsWithSetValues.add(PHASE_FIELD);
    }

    public String getReleaseComments() {
        return this.releaseComments;
    }

    public void setReleaseComments(String releaseComments) {
        this.releaseComments = releaseComments;
        this.fieldsWithSetValues.add(RELEASE_COMMENTS_FIELD);
    }

    public Date getReleasedOn() {
        return this.releasedOn;
    }

    public void setReleasedOn(Date releasedOn) {
        this.releasedOn = releasedOn;
        this.fieldsWithSetValues.add(RELEASED_ON_FIELD);
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
        this.fieldsWithSetValues.add(VERSION_NAME_FIELD);
    }

    private boolean fieldSet(Field field) {
        return this.fieldsWithSetValues.contains(field);
    }
}

