/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.dataservice;

import com.synopsys.integration.blackduck.api.core.BlackDuckComponent;
import com.synopsys.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.synopsys.integration.blackduck.api.generated.view.UserView;
import com.synopsys.integration.blackduck.api.manual.temporary.component.UserRequest;
import com.synopsys.integration.blackduck.http.BlackDuckPageDefinition;
import com.synopsys.integration.blackduck.http.BlackDuckPageResponse;
import com.synopsys.integration.blackduck.http.BlackDuckQuery;
import com.synopsys.integration.blackduck.http.BlackDuckRequestBuilder;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpUrl;
import java.util.List;
import java.util.Optional;

public class UserService
extends DataService {
    public UserService(BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, IntLogger logger) {
        super(blackDuckApiClient, blackDuckRequestFactory, logger);
    }

    public UserRequest createUserRequest(String username, String password, String firstName, String lastName) {
        UserRequest userRequest = new UserRequest();
        userRequest.setUserName(username);
        userRequest.setPassword(password);
        userRequest.setFirstName(firstName);
        userRequest.setLastName(lastName);
        userRequest.setActive(true);
        return userRequest;
    }

    public UserView createUser(UserRequest userRequest) throws IntegrationException {
        HttpUrl userUrl = this.blackDuckApiClient.post(ApiDiscovery.USERS_LINK, (BlackDuckComponent)userRequest);
        return this.blackDuckApiClient.getResponse(userUrl, UserView.class);
    }

    public BlackDuckPageResponse<UserView> findUsersByEmail(String emailSearchTerm, BlackDuckPageDefinition blackDuckPageDefinition) throws IntegrationException {
        HttpUrl usersUrl = this.blackDuckApiClient.getUrl(ApiDiscovery.USERS_LINK);
        Optional<BlackDuckQuery> usernameQuery = BlackDuckQuery.createQuery("email", emailSearchTerm);
        BlackDuckRequestBuilder blackDuckRequestBuilder = this.blackDuckRequestFactory.createCommonGetRequestBuilder(usersUrl, usernameQuery);
        return this.blackDuckApiClient.getPageResponse(blackDuckRequestBuilder, UserView.class, blackDuckPageDefinition);
    }

    public Optional<UserView> findUserByUsername(String username) throws IntegrationException {
        HttpUrl usersUrl = this.blackDuckApiClient.getUrl(ApiDiscovery.USERS_LINK);
        Optional<BlackDuckQuery> usernameQuery = BlackDuckQuery.createQuery("userName", username);
        BlackDuckRequestBuilder blackDuckRequestBuilder = this.blackDuckRequestFactory.createCommonGetRequestBuilder(usersUrl, usernameQuery);
        List<UserView> foundUsers = this.blackDuckApiClient.getSomeResponses(blackDuckRequestBuilder, UserView.class, 1);
        return foundUsers.stream().findFirst();
    }

    public List<UserView> getAllUsers() throws IntegrationException {
        return this.blackDuckApiClient.getAllResponses(ApiDiscovery.USERS_LINK_RESPONSE);
    }

    public BlackDuckPageResponse<UserView> getPageOfUsers(BlackDuckPageDefinition blackDuckPageDefinition) throws IntegrationException {
        return this.blackDuckApiClient.getPageResponse(ApiDiscovery.USERS_LINK_RESPONSE, blackDuckPageDefinition);
    }
}

