/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.dataservice;

import com.synopsys.integration.blackduck.api.core.BlackDuckComponent;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.api.generated.view.RoleView;
import com.synopsys.integration.blackduck.api.generated.view.UserView;
import com.synopsys.integration.blackduck.api.manual.temporary.component.RoleAssignmentRequest;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpUrl;
import org.jetbrains.annotations.NotNull;

public class UserRoleService
extends DataService {
    public UserRoleService(BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, IntLogger logger) {
        super(blackDuckApiClient, blackDuckRequestFactory, logger);
    }

    public void addServerRoleToUser(RoleView roleView, UserView userView) throws IntegrationException {
        RoleAssignmentRequest roleAssignmentRequest = this.initializeRequest(roleView);
        roleAssignmentRequest.setScope("server");
        this.createUserRole(userView, roleAssignmentRequest);
    }

    public void addProjectRoleToUser(RoleView roleView, ProjectView projectView, UserView userView) throws IntegrationException {
        RoleAssignmentRequest roleAssignmentRequest = this.initializeRequest(roleView);
        roleAssignmentRequest.setScope(projectView.getHref().string());
        this.createUserRole(userView, roleAssignmentRequest);
    }

    @NotNull
    private RoleAssignmentRequest initializeRequest(RoleView roleView) {
        RoleAssignmentRequest roleAssignmentRequest = new RoleAssignmentRequest();
        roleAssignmentRequest.setRole(roleView.getHref().string());
        return roleAssignmentRequest;
    }

    private void createUserRole(UserView userView, RoleAssignmentRequest roleAssignmentRequest) throws IntegrationException {
        HttpUrl userRoleUrl = userView.getFirstLink("roles");
        this.blackDuckApiClient.post(userRoleUrl, (BlackDuckComponent)roleAssignmentRequest);
    }
}

