/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.http.transform;

import com.synopsys.integration.blackduck.api.core.BlackDuckResponse;
import com.synopsys.integration.blackduck.exception.BlackDuckIntegrationException;
import com.synopsys.integration.blackduck.http.BlackDuckPageResponse;
import com.synopsys.integration.blackduck.http.PagedRequest;
import com.synopsys.integration.blackduck.http.client.BlackDuckHttpClient;
import com.synopsys.integration.blackduck.http.transform.BlackDuckJsonTransformer;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.response.Response;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class BlackDuckResponsesTransformer {
    private final BlackDuckHttpClient blackDuckHttpClient;
    private final BlackDuckJsonTransformer blackDuckJsonTransformer;

    public BlackDuckResponsesTransformer(BlackDuckHttpClient blackDuckHttpClient, BlackDuckJsonTransformer blackDuckJsonTransformer) {
        this.blackDuckHttpClient = blackDuckHttpClient;
        this.blackDuckJsonTransformer = blackDuckJsonTransformer;
    }

    public <T extends BlackDuckResponse> BlackDuckPageResponse<T> getSomeMatchingResponses(PagedRequest pagedRequest, Class<T> clazz, Predicate<T> predicate, int totalLimit) throws IntegrationException {
        return this.getInternalMatchingResponse(pagedRequest, clazz, totalLimit, predicate);
    }

    public <T extends BlackDuckResponse> BlackDuckPageResponse<T> getAllResponses(PagedRequest pagedRequest, Class<T> clazz) throws IntegrationException {
        return this.getInternalMatchingResponse(pagedRequest, clazz, Integer.MAX_VALUE, this.alwaysTrue());
    }

    public <T extends BlackDuckResponse> BlackDuckPageResponse<T> getSomeResponses(PagedRequest pagedRequest, Class<T> clazz, int totalLimit) throws IntegrationException {
        return this.getInternalMatchingResponse(pagedRequest, clazz, totalLimit, this.alwaysTrue());
    }

    public <T extends BlackDuckResponse> BlackDuckPageResponse<T> getOnePageOfResponses(PagedRequest pagedRequest, Class<T> clazz) throws IntegrationException {
        return this.getInternalMatchingResponse(pagedRequest, clazz, pagedRequest.getLimit(), this.alwaysTrue());
    }

    private <T extends BlackDuckResponse> Predicate<T> alwaysTrue() {
        return blackDuckResponse -> true;
    }

    private <T extends BlackDuckResponse> BlackDuckPageResponse<T> getInternalMatchingResponse(PagedRequest pagedRequest, Class<T> clazz, int maxToReturn, Predicate<T> predicate) throws IntegrationException {
        BlackDuckPageResponse blackDuckPageResponse;
        block16: {
            List<T> allResponses = new LinkedList<T>();
            int totalCount = 0;
            int currentOffset = pagedRequest.getOffset();
            Request request = pagedRequest.createRequest();
            Response initialResponse = this.blackDuckHttpClient.execute(request);
            try {
                this.blackDuckHttpClient.throwExceptionForError(initialResponse);
                String initialJsonResponse = initialResponse.getContentString();
                BlackDuckPageResponse<T> blackDuckPageResponse2 = this.blackDuckJsonTransformer.getResponses(initialJsonResponse, clazz);
                allResponses.addAll(this.matchPredicate(blackDuckPageResponse2, predicate));
                totalCount = blackDuckPageResponse2.getTotalCount();
                int totalItemsToRetrieve = Math.min(totalCount, maxToReturn);
                while (allResponses.size() < totalItemsToRetrieve && currentOffset < totalCount) {
                    PagedRequest offsetPagedRequest = new PagedRequest(pagedRequest.getRequestBuilder(), currentOffset += pagedRequest.getLimit(), pagedRequest.getLimit());
                    request = offsetPagedRequest.createRequest();
                    try {
                        Response response = this.blackDuckHttpClient.execute(request);
                        try {
                            this.blackDuckHttpClient.throwExceptionForError(response);
                            String jsonResponse = response.getContentString();
                            blackDuckPageResponse2 = this.blackDuckJsonTransformer.getResponses(jsonResponse, clazz);
                            allResponses.addAll(this.matchPredicate(blackDuckPageResponse2, predicate));
                        }
                        finally {
                            if (response == null) continue;
                            response.close();
                        }
                    }
                    catch (IOException e) {
                        throw new BlackDuckIntegrationException(e);
                    }
                }
                allResponses = this.onlyReturnMaxRequested(maxToReturn, allResponses);
                blackDuckPageResponse = new BlackDuckPageResponse(totalCount, allResponses);
                if (initialResponse == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (initialResponse != null) {
                        try {
                            initialResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BlackDuckIntegrationException(e.getMessage(), e);
                }
            }
            initialResponse.close();
        }
        return blackDuckPageResponse;
    }

    @NotNull
    private <T extends BlackDuckResponse> List<T> onlyReturnMaxRequested(int maxToReturn, List<T> allResponses) {
        return allResponses.stream().limit(maxToReturn).collect(Collectors.toList());
    }

    private <T extends BlackDuckResponse> List<T> matchPredicate(BlackDuckPageResponse<T> blackDuckPageResponse, Predicate<T> predicate) {
        return blackDuckPageResponse.getItems().stream().filter(predicate).collect(Collectors.toList());
    }
}

