/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.http.client;

import com.google.gson.Gson;
import com.synopsys.integration.blackduck.api.generated.discovery.BlackDuckMediaTypeDiscovery;
import com.synopsys.integration.blackduck.http.client.DefaultBlackDuckHttpClient;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.client.AuthenticatingIntHttpClient;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.response.Response;
import com.synopsys.integration.rest.support.AuthenticationSupport;
import com.synopsys.integration.util.NameVersion;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpUriRequest;

public class ApiTokenBlackDuckHttpClient
extends DefaultBlackDuckHttpClient {
    private final Gson gson;
    private final String apiToken;

    public ApiTokenBlackDuckHttpClient(IntLogger logger, int timeout, boolean alwaysTrustServerCertificate, ProxyInfo proxyInfo, HttpUrl baseUrl, NameVersion solutionDetails, Gson gson, AuthenticationSupport authenticationSupport, String apiToken, BlackDuckMediaTypeDiscovery blackDuckMediaTypeDiscovery) {
        super(logger, timeout, alwaysTrustServerCertificate, proxyInfo, baseUrl, solutionDetails, authenticationSupport, blackDuckMediaTypeDiscovery);
        this.gson = gson;
        this.apiToken = apiToken;
        if (StringUtils.isBlank((CharSequence)apiToken)) {
            throw new IllegalArgumentException("No API token was found.");
        }
    }

    @Override
    public final Response attemptAuthentication() throws IntegrationException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "token " + this.apiToken);
        return this.authenticationSupport.attemptAuthentication((AuthenticatingIntHttpClient)this, this.getBaseUrl(), "api/tokens/authenticate", headers);
    }

    @Override
    protected void completeAuthenticationRequest(HttpUriRequest request, Response response) {
        this.authenticationSupport.completeTokenAuthenticationRequest(request, response, this.logger, this.gson, this, "bearerToken");
    }
}

