/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.http;

import com.synopsys.integration.blackduck.http.BlackDuckPageDefinition;
import com.synopsys.integration.blackduck.http.BlackDuckQuery;
import com.synopsys.integration.blackduck.http.BlackDuckRequestBuilder;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFilter;
import com.synopsys.integration.rest.HttpMethod;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.body.FileBodyContent;
import com.synopsys.integration.rest.body.MapBodyContent;
import com.synopsys.integration.rest.body.MultipartBodyContent;
import com.synopsys.integration.rest.body.StringBodyContent;
import com.synopsys.integration.rest.request.Request;
import java.io.File;
import java.util.Map;
import java.util.Optional;

public class BlackDuckRequestFactory {
    public static final String LIMIT_PARAMETER = "limit";
    public static final String OFFSET_PARAMETER = "offset";
    public static final String Q_PARAMETER = "q";
    public static final String FILTER_PARAMETER = "filter";
    public static final int DEFAULT_LIMIT = 100;
    public static final int DEFAULT_OFFSET = 0;

    public Request createCommonGetRequest(HttpUrl url) {
        return (Request)this.createCommonGetRequestBuilder(url).getRequestBuilder().build();
    }

    public BlackDuckRequestBuilder createCommonGetRequestBuilder() {
        return this.createCommonGetRequestBuilder(null, Optional.empty(), 100, 0);
    }

    public BlackDuckRequestBuilder createCommonGetRequestBuilder(HttpUrl url) {
        return this.createCommonGetRequestBuilder(url, Optional.empty(), 100, 0);
    }

    public BlackDuckRequestBuilder createCommonGetRequestBuilder(Optional<BlackDuckQuery> blackDuckQuery) {
        return this.createCommonGetRequestBuilder(null, blackDuckQuery, 100, 0);
    }

    public BlackDuckRequestBuilder createCommonGetRequestBuilder(int limit, int offset) {
        return this.createCommonGetRequestBuilder(null, Optional.empty(), limit, offset);
    }

    public BlackDuckRequestBuilder createCommonGetRequestBuilder(HttpUrl url, Optional<BlackDuckQuery> blackDuckQuery) {
        return this.createCommonGetRequestBuilder(url, blackDuckQuery, 100, 0);
    }

    public BlackDuckRequestBuilder createCommonGetRequestBuilder(HttpUrl url, int limit, int offset) {
        return this.createCommonGetRequestBuilder(url, Optional.empty(), limit, offset);
    }

    public BlackDuckRequestBuilder createCommonGetRequestBuilder(Optional<BlackDuckQuery> blackDuckQuery, int limit, int offset) {
        return this.createCommonGetRequestBuilder(null, blackDuckQuery, limit, offset);
    }

    public BlackDuckRequestBuilder createCommonGetRequestBuilder(HttpUrl url, Optional<BlackDuckQuery> blackDuckQuery, int limit, int offset) {
        return this.createCommonGetRequestBuilder(url, blackDuckQuery, null, limit, offset);
    }

    public BlackDuckRequestBuilder createCommonGetRequestBuilder(HttpUrl url, Optional<BlackDuckQuery> blackDuckQuery, BlackDuckRequestFilter blackDuckRequestFilter, int limit, int offset) {
        return this.createRequestBuilder().url(url).addBlackDuckQuery(blackDuckQuery).addBlackDuckFilter(blackDuckRequestFilter).setBlackDuckPageDefinition(new BlackDuckPageDefinition(limit, offset));
    }

    public BlackDuckRequestBuilder createCommonPostRequestBuilder(HttpUrl url, File bodyContentFile) {
        return this.createRequestBuilder().url(url).method(HttpMethod.POST).bodyContent(new FileBodyContent(bodyContentFile));
    }

    public BlackDuckRequestBuilder createCommonPostRequestBuilder(HttpUrl url, Map<String, String> bodyContentMap) {
        return this.createRequestBuilder().url(url).method(HttpMethod.POST).bodyContent(new MapBodyContent(bodyContentMap));
    }

    public BlackDuckRequestBuilder createCommonPostRequestBuilder(HttpUrl url, String bodyContent) {
        return this.createRequestBuilder().url(url).method(HttpMethod.POST).bodyContent(new StringBodyContent(bodyContent));
    }

    public BlackDuckRequestBuilder createCommonPostRequestBuilder(Map<String, File> bodyContentFileMap, Map<String, String> bodyContentStringMap) {
        return this.createRequestBuilder().method(HttpMethod.POST).bodyContent(new MultipartBodyContent(bodyContentFileMap, bodyContentStringMap));
    }

    public BlackDuckRequestBuilder createCommonPutRequestBuilder(HttpUrl url, String bodyContent) {
        return this.createRequestBuilder().url(url).method(HttpMethod.PUT).bodyContent(new StringBodyContent(bodyContent));
    }

    private BlackDuckRequestBuilder createRequestBuilder() {
        return new BlackDuckRequestBuilder(new Request.Builder());
    }
}

