/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation.signaturescanner.command;

import com.synopsys.integration.blackduck.codelocation.CodeLocationOutput;
import com.synopsys.integration.blackduck.codelocation.Result;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanCommand;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.util.NameVersion;
import java.io.File;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;

public class ScanCommandOutput
extends CodeLocationOutput {
    public static final String DRY_RUN_RESULT_DIRECTORY = "data";
    public static final String SCAN_RESULT_DIRECTORY = "status";
    private final IntLogger logger;
    private final ScanCommand scanCommand;
    private final String executedScanCommand;
    private final Integer scanExitCode;

    public static ScanCommandOutput SUCCESS(NameVersion projectAndVersion, String codeLocationName, IntLogger logger, ScanCommand scanCommand, String executedScanCommand) {
        int expectedNotificationCount = ScanCommandOutput.calculateExpectedNotificationCount(scanCommand);
        return new ScanCommandOutput(projectAndVersion, codeLocationName, expectedNotificationCount, Result.SUCCESS, logger, scanCommand, executedScanCommand, null, null, 0);
    }

    public static ScanCommandOutput FAILURE(NameVersion projectAndVersion, String codeLocationName, IntLogger logger, ScanCommand scanCommand, String executedScanCommand, String errorMessage, Exception exception) {
        int expectedNotificationCount = ScanCommandOutput.calculateExpectedNotificationCount(scanCommand);
        return new ScanCommandOutput(projectAndVersion, codeLocationName, expectedNotificationCount, Result.FAILURE, logger, scanCommand, executedScanCommand, errorMessage, exception, null);
    }

    public static ScanCommandOutput FAILURE(NameVersion projectAndVersion, String codeLocationName, IntLogger logger, ScanCommand scanCommand, String executedScanCommand, int scanExitCode) {
        String errorMessage = String.format("The scan failed with return code: %d", scanExitCode);
        int expectedNotificationCount = ScanCommandOutput.calculateExpectedNotificationCount(scanCommand);
        return new ScanCommandOutput(projectAndVersion, codeLocationName, expectedNotificationCount, Result.FAILURE, logger, scanCommand, executedScanCommand, errorMessage, null, scanExitCode);
    }

    private static int calculateExpectedNotificationCount(ScanCommand scanCommand) {
        if (scanCommand.isSnippetMatching()) {
            return 2;
        }
        return 1;
    }

    private ScanCommandOutput(NameVersion projectAndVersion, String codeLocationName, int expectedNotificationCount, Result result, IntLogger logger, ScanCommand scanCommand, String executedScanCommand, String errorMessage, Exception exception, Integer scanExitCode) {
        super(result, projectAndVersion, codeLocationName, expectedNotificationCount, errorMessage, exception);
        this.logger = logger;
        this.scanCommand = scanCommand;
        this.executedScanCommand = executedScanCommand;
        this.scanExitCode = scanExitCode;
    }

    private Optional<File> getResultFile(String resultDirectoryName) {
        File[] resultFiles;
        File resultDirectory = new File(this.scanCommand.getOutputDirectory(), resultDirectoryName);
        if (null != resultDirectory && resultDirectory.exists() && null != (resultFiles = resultDirectory.listFiles((dir, name) -> FilenameUtils.wildcardMatchOnSystem((String)name, (String)"*.json"))) && resultFiles.length == 1) {
            return Optional.of(resultFiles[0]);
        }
        this.logger.error(String.format("Exactly 1 result file was not found in the result directory: %s", resultDirectory.getAbsolutePath()));
        return Optional.empty();
    }

    public boolean wasDryRun() {
        return this.scanCommand.isDryRun();
    }

    public Optional<File> getScanSummaryFile() {
        return this.getResultFile(SCAN_RESULT_DIRECTORY);
    }

    public Optional<File> getDryRunFile() {
        return this.getResultFile(DRY_RUN_RESULT_DIRECTORY);
    }

    public File getSpecificRunOutputDirectory() {
        return this.scanCommand.getOutputDirectory();
    }

    public String getScanTarget() {
        return this.scanCommand.getTargetPath();
    }

    public String getExecutedScanCommand() {
        return this.executedScanCommand;
    }

    public Optional<Integer> getScanExitCode() {
        return Optional.ofNullable(this.scanExitCode);
    }
}

