/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation.bdioupload;

import com.synopsys.integration.blackduck.codelocation.bdioupload.UploadOutput;
import com.synopsys.integration.blackduck.codelocation.bdioupload.UploadTarget;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.response.Response;
import com.synopsys.integration.util.NameVersion;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;

public class UploadCallable
implements Callable<UploadOutput> {
    private final BlackDuckApiClient blackDuckApiClient;
    private final BlackDuckRequestFactory blackDuckRequestFactory;
    private final UploadTarget uploadTarget;
    private final NameVersion projectAndVersion;
    private final String codeLocationName;

    public UploadCallable(BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, UploadTarget uploadTarget) {
        this.blackDuckApiClient = blackDuckApiClient;
        this.blackDuckRequestFactory = blackDuckRequestFactory;
        this.uploadTarget = uploadTarget;
        this.projectAndVersion = uploadTarget.getProjectAndVersion();
        this.codeLocationName = uploadTarget.getCodeLocationName();
    }

    @Override
    public UploadOutput call() {
        UploadOutput uploadOutput;
        block13: {
            String jsonPayload;
            try {
                jsonPayload = FileUtils.readFileToString((File)this.uploadTarget.getUploadFile(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                String errorMessage = String.format("Failed to initially read file: %s because %s", this.uploadTarget.getUploadFile().getAbsolutePath(), e.getMessage());
                return UploadOutput.FAILURE(this.projectAndVersion, this.codeLocationName, errorMessage, e);
            }
            HttpUrl url = this.blackDuckApiClient.getUrl(BlackDuckApiClient.BOMIMPORT_PATH);
            Request request = this.blackDuckRequestFactory.createCommonPostRequestBuilder(url, jsonPayload).acceptMimeType(this.uploadTarget.getMediaType()).build();
            Response response = this.blackDuckApiClient.execute(request);
            try {
                String responseString = response.getContentString();
                uploadOutput = UploadOutput.SUCCESS(this.projectAndVersion, this.codeLocationName, responseString);
                if (response == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return UploadOutput.FAILURE(this.projectAndVersion, this.codeLocationName, e.getMessage(), e);
                    }
                }
                catch (Exception e) {
                    String errorMessage = String.format("Failed to upload file: %s because %s", this.uploadTarget.getUploadFile().getAbsolutePath(), e.getMessage());
                    return UploadOutput.FAILURE(this.projectAndVersion, this.codeLocationName, errorMessage, e);
                }
            }
            response.close();
        }
        return uploadOutput;
    }
}

