/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.dataservice;

import com.synopsys.integration.blackduck.api.core.BlackDuckComponent;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.api.generated.view.TagView;
import com.synopsys.integration.blackduck.exception.BlackDuckIntegrationException;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.blackduck.service.DataService;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpUrl;
import java.util.List;
import java.util.Optional;

public class TagService
extends DataService {
    public TagService(BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory, IntLogger logger) {
        super(blackDuckApiClient, blackDuckRequestFactory, logger);
    }

    public List<TagView> getAllTags(ProjectView projectView) throws IntegrationException {
        return this.blackDuckApiClient.getAllResponses(projectView, ProjectView.TAGS_LINK_RESPONSE);
    }

    public Optional<TagView> findMatchingTag(ProjectView projectView, String tagName) throws IntegrationException {
        return this.getAllTags(projectView).stream().filter(tagView -> tagView.getName().equals(tagName)).findFirst();
    }

    public void updateTag(TagView tag) throws IntegrationException {
        this.blackDuckApiClient.put(tag);
    }

    public TagView createTag(ProjectView projectView, TagView tag) throws IntegrationException {
        if (!projectView.hasLink("tags")) {
            throw new BlackDuckIntegrationException(String.format("The supplied projectView does not have the link (%s) to create a tag.", "tags"));
        }
        HttpUrl tagsLink = projectView.getFirstLink("tags");
        HttpUrl tagLink = this.blackDuckApiClient.post(tagsLink, (BlackDuckComponent)tag);
        return this.blackDuckApiClient.getResponse(tagLink, TagView.class);
    }
}

