/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.pdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class StringManager {
    public static List<String> wrapToCombinedList(PDFont font, float fontSize, String str, float widthLimit) throws IOException {
        List<String> nonBlankWords = StringManager.breakIntoWordsIfTooLong(font, fontSize, str, widthLimit);
        List<String> nonBlankTrimmedFinalStrings = StringManager.recombineBrokenWordsIfPossible(font, fontSize, widthLimit, nonBlankWords);
        return nonBlankTrimmedFinalStrings;
    }

    private static List<String> breakIntoWordsIfTooLong(PDFont font, float fontSize, String str, float widthLimit) throws IOException {
        ArrayList<String> words = new ArrayList<String>(Arrays.asList(str.split(" ")));
        for (int i = 0; i < words.size(); ++i) {
            String word = (String)words.get(i);
            float stringWidth = StringManager.getStringWidth(font, fontSize, word);
            if (!(stringWidth > widthLimit)) continue;
            words.remove(word);
            List<String> brokenStrings = StringManager.breakWrapString(font, fontSize, word, widthLimit);
            words.addAll(i, brokenStrings);
            i += brokenStrings.size();
        }
        return words.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private static List<String> recombineBrokenWordsIfPossible(PDFont font, float fontSize, float widthLimit, List<String> nonBlankWords) throws IOException {
        ArrayList<String> finalStrings = new ArrayList<String>();
        StringBuilder currentBuilder = new StringBuilder();
        for (String word : nonBlankWords) {
            if (StringManager.wouldExceedLimit(currentBuilder, word, font, fontSize, widthLimit)) {
                finalStrings.add(currentBuilder.toString());
                currentBuilder = new StringBuilder(word);
                continue;
            }
            currentBuilder.append(" ");
            currentBuilder.append(word);
        }
        finalStrings.add(currentBuilder.toString());
        return finalStrings.stream().filter(StringUtils::isNotBlank).map(StringUtils::trim).collect(Collectors.toList());
    }

    private static boolean wouldExceedLimit(StringBuilder builder, String toAdd, PDFont font, float fontSize, float widthLimit) throws IOException {
        return StringManager.getStringWidth(font, fontSize, builder.toString()) + StringManager.getStringWidth(font, fontSize, toAdd) > widthLimit;
    }

    public static float getStringWidth(PDFont font, float fontSize, String text) throws IOException {
        String fixedText = StringManager.replaceUnsupportedCharacters(text, font);
        float rawLength = font.getStringWidth(fixedText);
        return rawLength * (fontSize / 960.0f);
    }

    public static List<String> breakWrapString(PDFont font, float fontSize, String str, float widthLimit) throws IOException {
        int lastBreak = 0;
        float maxLengthCounter = 0.0f;
        int strLen = str.length();
        ArrayList<String> brokenUpStrings = new ArrayList<String>();
        for (int i = 1; i < strLen; ++i) {
            if (!StringUtils.isAlphanumeric((CharSequence)(str.charAt(i) + "")) || maxLengthCounter >= widthLimit) {
                brokenUpStrings.add(str.substring(lastBreak, i));
                lastBreak = i;
                maxLengthCounter = 0.0f;
                continue;
            }
            maxLengthCounter = StringManager.getStringWidth(font, fontSize, str.substring(lastBreak, i));
        }
        if (brokenUpStrings.isEmpty() || maxLengthCounter > 0.0f && maxLengthCounter < widthLimit) {
            brokenUpStrings.add(str.substring(lastBreak, strLen));
        }
        ArrayList<String> finalStrings = new ArrayList<String>();
        String currentStringCombo = "";
        for (String currentBrokenString : brokenUpStrings) {
            if (StringManager.getStringWidth(font, fontSize, currentStringCombo) + StringManager.getStringWidth(font, fontSize, currentBrokenString) > widthLimit) {
                finalStrings.add(currentStringCombo);
                currentStringCombo = currentBrokenString;
                continue;
            }
            currentStringCombo = currentStringCombo + currentBrokenString;
        }
        if (currentStringCombo.length() > 0) {
            finalStrings.add(currentStringCombo);
        }
        return finalStrings;
    }

    public static String replaceUnsupportedCharacters(String text, PDFont font) {
        return StringManager.replaceUnsupportedCharacters(text, Collections.singletonList(font));
    }

    public static String replaceUnsupportedCharacters(String text, List<PDFont> fonts) {
        String result = "";
        if (text.length() > 0) {
            int codeChars;
            for (int i = 0; i < text.length(); i += codeChars) {
                int codePoint = text.codePointAt(i);
                codeChars = Character.charCount(codePoint);
                String codePointString = text.substring(i, i + codeChars);
                boolean canEncode = false;
                for (PDFont font : fonts) {
                    try {
                        font.encode(codePointString);
                        canEncode = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                result = canEncode ? result + codePointString : result + "?";
            }
        }
        return result;
    }
}

