/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.builder;

import com.synopsys.integration.builder.Buildable;
import com.synopsys.integration.builder.BuilderStatus;

public abstract class IntegrationBuilder<T extends Buildable> {
    public T build() throws IllegalArgumentException {
        this.assertValid();
        return this.buildWithoutValidation();
    }

    protected abstract T buildWithoutValidation();

    protected abstract void validate(BuilderStatus var1);

    public final void assertValid() throws IllegalArgumentException {
        BuilderStatus builderStatus = this.validateAndGetBuilderStatus();
        if (!builderStatus.isValid()) {
            throw new IllegalArgumentException(builderStatus.getFullErrorMessage());
        }
    }

    public final boolean isValid() {
        BuilderStatus builderStatus = this.validateAndGetBuilderStatus();
        return builderStatus.isValid();
    }

    public final BuilderStatus validateAndGetBuilderStatus() {
        BuilderStatus builderStatus = new BuilderStatus();
        this.validate(builderStatus);
        return builderStatus;
    }
}

