/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.bdio;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.synopsys.integration.bdio.model.BdioNode;
import com.synopsys.integration.bdio.model.SimpleBdioDocument;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class BdioWriter
implements Closeable {
    private final Gson gson;
    private final JsonWriter jsonWriter;

    public BdioWriter(Gson gson, Writer writer) throws IOException {
        this.gson = gson;
        this.jsonWriter = new JsonWriter(writer);
        this.jsonWriter.setIndent("  ");
        this.jsonWriter.beginArray();
    }

    public BdioWriter(Gson gson, OutputStream outputStream) throws IOException {
        this.gson = gson;
        this.jsonWriter = new JsonWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        this.jsonWriter.setIndent("  ");
        this.jsonWriter.beginArray();
    }

    public void writeSimpleBdioDocument(SimpleBdioDocument simpleBdioDocument) {
        ArrayList<BdioNode> bdioNodes = new ArrayList<BdioNode>();
        bdioNodes.add(simpleBdioDocument.getBillOfMaterials());
        bdioNodes.add(simpleBdioDocument.getProject());
        if (simpleBdioDocument.getComponents() != null && !simpleBdioDocument.getComponents().isEmpty()) {
            bdioNodes.addAll(simpleBdioDocument.getComponents());
        }
        this.writeBdioNodes(bdioNodes);
    }

    public void writeBdioNodes(List<? extends BdioNode> bdioNodes) {
        for (BdioNode bdioNode : bdioNodes) {
            this.writeBdioNode(bdioNode);
        }
    }

    public void writeBdioNode(BdioNode bdioNode) {
        this.gson.toJson((Object)bdioNode, bdioNode.getClass(), this.jsonWriter);
    }

    @Override
    public void close() throws IOException {
        this.jsonWriter.endArray();
        this.jsonWriter.close();
    }
}

