/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation;

import com.synopsys.integration.blackduck.codelocation.CodeLocationOutput;
import com.synopsys.integration.blackduck.codelocation.Result;
import com.synopsys.integration.util.NameVersion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class CodeLocationBatchOutput<T extends CodeLocationOutput>
implements Iterable<T> {
    private final Map<String, Integer> successfulCodeLocationNamesToExpectedNotificationCounts;
    private final List<T> outputs = new ArrayList<T>();

    public CodeLocationBatchOutput(List<T> outputs) {
        this.successfulCodeLocationNamesToExpectedNotificationCounts = outputs.stream().peek(this.outputs::add).filter(output -> Result.SUCCESS == output.getResult()).filter(output -> StringUtils.isNotBlank((CharSequence)output.getCodeLocationName())).collect(Collectors.toMap(CodeLocationOutput::getCodeLocationName, CodeLocationOutput::getExpectedNotificationCount));
    }

    public List<T> getOutputs() {
        return this.outputs;
    }

    public NameVersion getProjectAndVersion() {
        return this.outputs.stream().map(CodeLocationOutput::getProjectAndVersion).findFirst().get();
    }

    public Set<String> getSuccessfulCodeLocationNames() {
        return this.successfulCodeLocationNamesToExpectedNotificationCounts.keySet();
    }

    public int getExpectedNotificationCount() {
        return this.successfulCodeLocationNamesToExpectedNotificationCounts.values().stream().mapToInt(Integer::intValue).sum();
    }

    public boolean hasAnyFailures() {
        return this.outputs.stream().map(CodeLocationOutput::getResult).anyMatch(Result.FAILURE::equals);
    }

    @Override
    public Iterator<T> iterator() {
        return this.outputs.iterator();
    }
}

