/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.service.model.BomComponent;
import com.synopsys.integration.blackduck.service.model.BomRiskCounts;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class ReportData {
    private String projectName;
    private String projectURL;
    private String projectVersion;
    private String projectVersionURL;
    private String phase;
    private String distribution;
    private List<BomComponent> components;
    private int totalComponents;
    private LocalDateTime dateTimeOfLatestScan;
    private BomRiskCounts securityRiskCounts = new BomRiskCounts();
    private BomRiskCounts licenseRiskCounts = new BomRiskCounts();
    private BomRiskCounts operationalRiskCounts = new BomRiskCounts();
    private int vulnerabilityRiskNoneCount;
    private int licenseRiskNoneCount;
    private int operationalRiskNoneCount;

    public String htmlEscape(String valueToEscape) {
        if (StringUtils.isBlank((CharSequence)valueToEscape)) {
            return null;
        }
        return StringEscapeUtils.escapeHtml4((String)valueToEscape);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectURL() {
        return this.projectURL;
    }

    public void setProjectURL(String projectURL) {
        this.projectURL = projectURL;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public String getProjectVersionURL() {
        return this.projectVersionURL;
    }

    public void setProjectVersionURL(String projectVersionURL) {
        this.projectVersionURL = projectVersionURL;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public int getTotalComponents() {
        return this.totalComponents;
    }

    public Optional<LocalDateTime> getDateTimeOfLatestScan() {
        return Optional.ofNullable(this.dateTimeOfLatestScan);
    }

    public void setDateTimeOfLatestScan(LocalDateTime dateTimeOfLatestScan) {
        this.dateTimeOfLatestScan = dateTimeOfLatestScan;
    }

    public int getVulnerabilityRiskHighCount() {
        return this.securityRiskCounts.getHigh();
    }

    public int getVulnerabilityRiskMediumCount() {
        return this.securityRiskCounts.getMedium();
    }

    public int getVulnerabilityRiskLowCount() {
        return this.securityRiskCounts.getLow();
    }

    public int getVulnerabilityRiskNoneCount() {
        return this.vulnerabilityRiskNoneCount;
    }

    public int getLicenseRiskHighCount() {
        return this.licenseRiskCounts.getHigh();
    }

    public int getLicenseRiskMediumCount() {
        return this.licenseRiskCounts.getMedium();
    }

    public int getLicenseRiskLowCount() {
        return this.licenseRiskCounts.getLow();
    }

    public int getLicenseRiskNoneCount() {
        return this.licenseRiskNoneCount;
    }

    public int getOperationalRiskHighCount() {
        return this.operationalRiskCounts.getHigh();
    }

    public int getOperationalRiskMediumCount() {
        return this.operationalRiskCounts.getMedium();
    }

    public int getOperationalRiskLowCount() {
        return this.operationalRiskCounts.getLow();
    }

    public int getOperationalRiskNoneCount() {
        return this.operationalRiskNoneCount;
    }

    public List<BomComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<BomComponent> components) {
        this.components = components;
        for (BomComponent component : components) {
            this.securityRiskCounts.add(component.getSecurityRiskCounts());
            this.licenseRiskCounts.add(component.getLicenseRiskCounts());
            this.operationalRiskCounts.add(component.getOperationalRiskCounts());
        }
        this.totalComponents = components.size();
        this.vulnerabilityRiskNoneCount = this.totalComponents - this.getVulnerabilityRiskHighCount() - this.getVulnerabilityRiskMediumCount() - this.getVulnerabilityRiskLowCount();
        this.licenseRiskNoneCount = this.totalComponents - this.getLicenseRiskHighCount() - this.getLicenseRiskMediumCount() - this.getLicenseRiskLowCount();
        this.operationalRiskNoneCount = this.totalComponents - this.getOperationalRiskHighCount() - this.getOperationalRiskMediumCount() - this.getOperationalRiskLowCount();
    }
}

