/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.flipkart.zjsonpatch.JsonDiff;
import com.flipkart.zjsonpatch.JsonPatch;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.component.IntRestComponent;
import com.synopsys.integration.rest.component.IntRestResponse;
import com.synopsys.integration.rest.response.Response;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IntJsonTransformer {
    private final Gson gson;
    private final IntLogger logger;

    public IntJsonTransformer(Gson gson, IntLogger logger) {
        this.gson = gson;
        this.logger = logger;
    }

    public <R extends IntRestResponse> R getResponse(Response response, Type responseType) throws IntegrationException {
        String json = response.getContentString();
        IntRestResponse transformedResponse = (IntRestResponse)this.getComponentAs(json, responseType);
        transformedResponse.setGson(this.gson);
        return (R)transformedResponse;
    }

    public <C extends IntRestComponent> C getComponentAs(String json, Type responseType) throws IntegrationException {
        try {
            JsonObject jsonElement = (JsonObject)this.gson.fromJson(json, JsonObject.class);
            return this.getComponentAs(jsonElement, responseType);
        }
        catch (JsonSyntaxException e) {
            this.logger.error(String.format("Could not parse the provided json with Gson:%s%s", System.lineSeparator(), json));
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public <C extends IntRestComponent> C getComponentAs(JsonObject jsonObject, Type responseType) throws IntegrationException {
        String json = this.gson.toJson((JsonElement)jsonObject);
        if (null == jsonObject || StringUtils.isBlank((CharSequence)json)) {
            throw new IntegrationException(String.format("The server did not have a response body. Can not convert the response to '%s'", responseType.getTypeName()));
        }
        try {
            this.addJsonAsField((JsonElement)jsonObject);
            IntRestComponent transformedResponse = (IntRestComponent)this.gson.fromJson((JsonElement)jsonObject, responseType);
            transformedResponse.setJsonElement((JsonElement)jsonObject);
            return (C)transformedResponse;
        }
        catch (JsonSyntaxException e) {
            this.logger.error(String.format("Could not parse the provided jsonElement with Gson:%s%s", System.lineSeparator(), json));
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    private void addJsonAsField(JsonElement jsonElement) {
        block4: {
            block3: {
                if (null == jsonElement) {
                    return;
                }
                if (!jsonElement.isJsonObject()) break block3;
                JsonObject innerObject = jsonElement.getAsJsonObject();
                String innerObjectJson = this.gson.toJson((JsonElement)innerObject);
                innerObject.addProperty("json", innerObjectJson);
                for (Map.Entry innerObjectFields : innerObject.entrySet()) {
                    this.addJsonAsField((JsonElement)innerObjectFields.getValue());
                }
                break block4;
            }
            if (!jsonElement.isJsonArray()) break block4;
            for (JsonElement arrayElement : jsonElement.getAsJsonArray()) {
                this.addJsonAsField(arrayElement);
            }
        }
    }

    public void setPatch(IntRestResponse intRestResponse, ObjectMapper objectMapper) {
        String lossyJson = this.gson.toJson((Object)intRestResponse);
        try {
            JsonNode source = objectMapper.readTree(lossyJson);
            JsonNode target = objectMapper.readTree(intRestResponse.getJson());
            JsonNode patch = JsonDiff.asJson(source, target);
            intRestResponse.setPatch(patch);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String producePatchedJson(IntRestResponse intRestResponse, ObjectMapper objectMapper) {
        String lossyJson = this.gson.toJson((Object)intRestResponse);
        try {
            JsonNode target = objectMapper.readTree(lossyJson);
            JsonNode patch = intRestResponse.getPatch();
            List<JsonNode> listOfPatches = this.transformPatchToListOfPatches(patch);
            for (JsonNode singleChangePatch : listOfPatches) {
                try {
                    target = JsonPatch.apply(singleChangePatch, target);
                }
                catch (Exception e) {
                    this.logger.warn("Could not apply a particular change - this may not be an issue if change involves an object that wasn't being updated: " + e.getMessage());
                }
            }
            StringWriter stringWriter = new StringWriter();
            objectMapper.writeValue((Writer)stringWriter, (Object)target);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<JsonNode> transformPatchToListOfPatches(JsonNode patch) {
        ArrayList<JsonNode> listOfPatches = new ArrayList<JsonNode>();
        for (JsonNode change : patch) {
            ArrayNode changeArray = JsonNodeFactory.instance.arrayNode(1);
            changeArray.add(change);
            listOfPatches.add((JsonNode)changeArray);
        }
        return listOfPatches;
    }
}

