/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.wait;

import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.wait.WaitJobConfig;
import com.synopsys.integration.wait.WaitJobTask;
import java.time.Duration;
import java.util.function.Supplier;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class WaitJob {
    private WaitJobConfig waitJobConfig;

    public static WaitJob create(IntLogger intLogger, long timeoutInSeconds, long startTime, int waitIntervalInSeconds, WaitJobTask waitJobTask) {
        return new WaitJob(new WaitJobConfig(intLogger, timeoutInSeconds, startTime, waitIntervalInSeconds, waitJobTask));
    }

    public static WaitJob create(IntLogger intLogger, long timeoutInSeconds, Supplier<Long> startTimeSupplier, int waitIntervalInSeconds, WaitJobTask waitJobTask) {
        return new WaitJob(new WaitJobConfig(intLogger, timeoutInSeconds, startTimeSupplier, waitIntervalInSeconds, waitJobTask));
    }

    public static WaitJob createUsingSystemTimeWhenInvoked(IntLogger intLogger, long timeoutInSeconds, int waitIntervalInSeconds, WaitJobTask waitJobTask) {
        return new WaitJob(new WaitJobConfig(intLogger, timeoutInSeconds, WaitJobConfig.CURRENT_TIME_SUPPLIER, waitIntervalInSeconds, waitJobTask));
    }

    public static WaitJob create(IntLogger intLogger, long timeoutInSeconds, long startTime, int waitIntervalInSeconds, String taskName, WaitJobTask waitJobTask) {
        return new WaitJob(new WaitJobConfig(intLogger, timeoutInSeconds, startTime, waitIntervalInSeconds, taskName, waitJobTask));
    }

    public static WaitJob create(IntLogger intLogger, long timeoutInSeconds, Supplier<Long> startTimeSupplier, int waitIntervalInSeconds, String taskName, WaitJobTask waitJobTask) {
        return new WaitJob(new WaitJobConfig(intLogger, timeoutInSeconds, startTimeSupplier, waitIntervalInSeconds, taskName, waitJobTask));
    }

    public static WaitJob createUsingSystemTimeWhenInvoked(IntLogger intLogger, long timeoutInSeconds, int waitIntervalInSeconds, String taskName, WaitJobTask waitJobTask) {
        return new WaitJob(new WaitJobConfig(intLogger, timeoutInSeconds, WaitJobConfig.CURRENT_TIME_SUPPLIER, waitIntervalInSeconds, taskName, waitJobTask));
    }

    public WaitJob(WaitJobConfig waitJobConfig) {
        this.waitJobConfig = waitJobConfig;
    }

    public boolean waitFor() throws InterruptedException, IntegrationException {
        int attempts = 0;
        long startTime = this.waitJobConfig.getStartTime();
        Duration currentDuration = Duration.ZERO;
        Duration maximumDuration = Duration.ofMillis(this.waitJobConfig.getTimeoutInSeconds() * 1000L);
        IntLogger intLogger = this.waitJobConfig.getIntLogger();
        String taskDescription = this.waitJobConfig.getTaskName().map(s2 -> String.format("for task %s ", s2)).orElse("");
        while (currentDuration.compareTo(maximumDuration) <= 0) {
            String attemptMessagePrefix = String.format("Try #%s %s(elapsed: %s)...", ++attempts, taskDescription, DurationFormatUtils.formatDurationHMS((long)currentDuration.toMillis()));
            if (this.waitJobConfig.getWaitJobTask().isComplete()) {
                intLogger.info(String.format("%scomplete!", attemptMessagePrefix));
                return true;
            }
            intLogger.info(String.format("%snot done yet, waiting %s seconds and trying again...", attemptMessagePrefix, this.waitJobConfig.getWaitIntervalInSeconds()));
            Thread.sleep(this.waitJobConfig.getWaitIntervalInSeconds() * 1000);
            currentDuration = Duration.ofMillis(System.currentTimeMillis() - startTime);
        }
        return false;
    }
}

